/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.config;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class Messages {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private final Map<String, String> messages = new HashMap<String, String>();

    public void setMessage(@NotNull String key, @NotNull String message) {
        this.messages.put(key, message);
    }

    @NotNull
    public String get(@NotNull String key) {
        String message = this.messages.getOrDefault(key, "&cMessage not found: " + key);
        return this.convertColors(message);
    }

    @NotNull
    public String get(@NotNull String key, @NotNull Map<String, String> placeholders) {
        String message = this.get(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    @NotNull
    public Component getComponent(@NotNull String key) {
        return LEGACY_SERIALIZER.deserialize(this.get(key));
    }

    @NotNull
    public Component getComponent(@NotNull String key, @NotNull Map<String, String> placeholders) {
        return LEGACY_SERIALIZER.deserialize(this.get(key, placeholders));
    }

    @NotNull
    private String convertColors(@NotNull String message) {
        return message.replace("&0", "\u00a70").replace("&1", "\u00a71").replace("&2", "\u00a72").replace("&3", "\u00a73").replace("&4", "\u00a74").replace("&5", "\u00a75").replace("&6", "\u00a76").replace("&7", "\u00a77").replace("&8", "\u00a78").replace("&9", "\u00a79").replace("&a", "\u00a7a").replace("&b", "\u00a7b").replace("&c", "\u00a7c").replace("&d", "\u00a7d").replace("&e", "\u00a7e").replace("&f", "\u00a7f").replace("&k", "\u00a7k").replace("&l", "\u00a7l").replace("&m", "\u00a7m").replace("&n", "\u00a7n").replace("&o", "\u00a7o").replace("&r", "\u00a7r");
    }

    public int size() {
        return this.messages.size();
    }

    public boolean has(@NotNull String key) {
        return this.messages.containsKey(key);
    }

    @NotNull
    public String noFarm() {
        return this.get("no_farm");
    }

    @NotNull
    public String noPermission() {
        return this.get("no_permission");
    }

    @NotNull
    public String playerNotFound() {
        return this.get("player_not_found");
    }

    @NotNull
    public String dbError() {
        return this.get("db_error");
    }

    @NotNull
    public String unknownCommand() {
        return this.get("unknown_command");
    }

    @NotNull
    public String alreadyHasFarm() {
        return this.get("already_has_farm");
    }

    @NotNull
    public String farmCreated(String name) {
        return this.get("farm_created", Map.of("name", name));
    }

    @NotNull
    public String farmDeleted() {
        return this.get("farm_deleted");
    }

    @NotNull
    public String invalidFarmName() {
        return this.get("invalid_farm_name");
    }

    @NotNull
    public String farmOverlaps() {
        return this.get("farm_overlaps");
    }

    @NotNull
    public String errorCreatingFarm(String error) {
        return this.get("error_creating_farm", Map.of("error", error));
    }

    @NotNull
    public String enterFarm() {
        return this.get("enter_farm");
    }

    @NotNull
    public String leaveFarm() {
        return this.get("leave_farm");
    }

    @NotNull
    public String insufficientFunds(String cost) {
        return this.get("insufficient_coins", Map.of("cost", cost));
    }

    @NotNull
    public String upgradeSuccess(int level) {
        return this.get("upgrade_success", Map.of("level", String.valueOf(level)));
    }

    @NotNull
    public String upgradeSuccessDetailed(int level, int oldSize, int newSize, int increase) {
        return this.get("upgrade_success_detailed", Map.of("level", String.valueOf(level), "old_size", String.valueOf(oldSize), "new_size", String.valueOf(newSize), "increase", String.valueOf(increase)));
    }

    @NotNull
    public String upgradeWouldOverlap() {
        return this.get("upgrade_would_overlap");
    }

    @NotNull
    public String maxLevelReached() {
        return this.get("max_level_reached");
    }

    @NotNull
    public String jobsLevelTooLow(int level, String job, int farmLevel) {
        return this.get("jobs_level_too_low", Map.of("level", String.valueOf(level), "job", job, "farm_level", String.valueOf(farmLevel)));
    }

    @NotNull
    public String homeSet() {
        return this.get("home_set");
    }

    @NotNull
    public String teleportedHome() {
        return this.get("teleported_home");
    }

    @NotNull
    public String noHomeSet() {
        return this.get("no_home_set");
    }

    @NotNull
    public String notInFarm() {
        return this.get("not_in_farm");
    }

    @NotNull
    public String visitOpened() {
        return this.get("visit_opened");
    }

    @NotNull
    public String visitClosed() {
        return this.get("visit_closed");
    }

    @NotNull
    public String visitsClosed(String playerName) {
        return this.get("visits_closed", Map.of("player", playerName));
    }

    @NotNull
    public String teleportedToFarm(String playerName) {
        return this.get("teleported_to_farm", Map.of("player", playerName));
    }

    @NotNull
    public String inviteSent(String playerName) {
        return this.get("invite_sent", Map.of("player", playerName));
    }

    @NotNull
    public String inviteReceived(String playerName) {
        return this.get("invite_received", Map.of("player", playerName));
    }

    @NotNull
    public String inviteAlreadyCoOwner(String playerName) {
        return this.get("invite_already_coowner", Map.of("player", playerName));
    }

    @NotNull
    public String maxCoOwnersReached(int max) {
        return this.get("max_coowners_reached", Map.of("max", String.valueOf(max)));
    }

    @NotNull
    public String noPendingInvitation() {
        return this.get("no_pending_invitation");
    }

    @NotNull
    public String joinSuccess(String ownerName) {
        return this.get("join_success", Map.of("owner", ownerName));
    }

    @NotNull
    public String quitSuccess(String ownerName) {
        return this.get("quit_success", Map.of("owner", ownerName));
    }

    @NotNull
    public String ownerCannotQuit() {
        return this.get("owner_cannot_quit");
    }

    @NotNull
    public String removeSuccess(String playerName) {
        return this.get("remove_success", Map.of("player", playerName));
    }

    @NotNull
    public String removeNotCoOwner(String playerName) {
        return this.get("remove_not_coowner", Map.of("player", playerName));
    }

    @NotNull
    public String removedFromFarm(String ownerName) {
        return this.get("removed_from_farm", Map.of("owner", ownerName));
    }

    @NotNull
    public String cannotBreakOtherFarm() {
        return this.get("cannot_break_other_farm");
    }

    @NotNull
    public String cannotPlaceOtherFarm() {
        return this.get("cannot_place_other_farm");
    }

    @NotNull
    public String reloadSuccess() {
        return this.get("reload_success");
    }

    @NotNull
    public String adminUsage() {
        return this.get("admin_usage");
    }

    @NotNull
    public String adminUnknownCommand() {
        return this.get("admin_unknown_command");
    }
}

