/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.ActivityLog;
import com.skynex.mylands.model.Land;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableActivityLogsGui
implements LandGui {
    private static final String GUI_NAME = "activity_logs_menu";
    private static final int LOGS_PER_PAGE = 45;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    private final GuiManager guiManager;
    private final GuiConfig guiConfig;
    private final Land land;
    private final int page;
    private final List<ActivityLog> logs;

    public ConfigurableActivityLogsGui(@NotNull GuiManager guiManager, @NotNull GuiConfig guiConfig, @NotNull Land land) {
        this(guiManager, guiConfig, land, 0);
    }

    public ConfigurableActivityLogsGui(@NotNull GuiManager guiManager, @NotNull GuiConfig guiConfig, @NotNull Land land, int page) {
        this.guiManager = guiManager;
        this.guiConfig = guiConfig;
        this.land = land;
        this.page = page;
        this.logs = this.generateSampleLogs();
    }

    private List<ActivityLog> generateSampleLogs() {
        ArrayList<ActivityLog> sampleLogs = new ArrayList<ActivityLog>();
        long now = System.currentTimeMillis();
        sampleLogs.add(new ActivityLog(this.land.ownerId(), "LAND_CREATED", "Created land: " + this.land.name(), now - 86400000L));
        sampleLogs.add(new ActivityLog(this.land.ownerId(), "LAND_UPGRADED", "Upgraded to level " + this.land.level(), now - 43200000L));
        sampleLogs.add(new ActivityLog(this.land.ownerId(), "HOME_SET", "Set home location", now - 21600000L));
        sampleLogs.add(new ActivityLog(this.land.ownerId(), "VISITS_TOGGLED", "Visits " + (this.land.visitsOpen() ? "opened" : "closed"), now - 10800000L));
        return sampleLogs;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.displayLogs(inv);
        if (this.page > 0) {
            this.createNavigationItem(inv, "previous_page");
        }
        this.createNavigationItem(inv, "current_page");
        if ((this.page + 1) * 45 < this.logs.size()) {
            this.createNavigationItem(inv, "next_page");
        }
        this.createItem(inv, "back");
        return inv;
    }

    private void displayLogs(@NotNull Inventory inv) {
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.logs.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ActivityLog log = this.logs.get(i);
            Material material = this.getLogMaterial(log.action());
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.getLogColor(log.action()) + log.action().replace("_", " "));
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                lore.add("\u00a77" + log.description());
                lore.add("");
                lore.add("\u00a77\ud83d\udcc5 " + DATE_FORMAT.format(new Date(log.timestamp())));
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.setItem(i - startIndex, item);
        }
    }

    private Material getLogMaterial(String action) {
        return switch (action) {
            case "LAND_CREATED" -> Material.GRASS_BLOCK;
            case "LAND_UPGRADED" -> Material.EXPERIENCE_BOTTLE;
            case "LAND_DELETED" -> Material.BARRIER;
            case "MEMBER_ADDED" -> Material.PLAYER_HEAD;
            case "MEMBER_REMOVED" -> Material.SKELETON_SKULL;
            case "HOME_SET" -> Material.RED_BED;
            case "VISITS_TOGGLED" -> Material.OAK_DOOR;
            case "ZONE_DISPLAYED" -> Material.COMPASS;
            default -> Material.PAPER;
        };
    }

    private String getLogColor(String action) {
        return switch (action) {
            case "LAND_CREATED", "LAND_UPGRADED", "MEMBER_ADDED", "HOME_SET" -> "\u00a7a\u00a7l";
            case "LAND_DELETED", "MEMBER_REMOVED" -> "\u00a7c\u00a7l";
            case "VISITS_TOGGLED", "ZONE_DISPLAYED" -> "\u00a7e\u00a7l";
            default -> "\u00a77\u00a7l";
        };
    }

    private void createNavigationItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("page", String.valueOf(this.page + 1));
        placeholders.put("max_page", String.valueOf((this.logs.size() + 45 - 1) / 45));
        placeholders.put("prev_page", String.valueOf(this.page));
        placeholders.put("next_page", String.valueOf(this.page + 2));
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name = itemConfig.getName();
            for (Map.Entry entry : placeholders.entrySet()) {
                name = name.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
            }
            meta.setDisplayName(name);
            meta.setLore(itemConfig.getLore(placeholders));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(itemConfig.getName());
            meta.setLore(itemConfig.getLore(new HashMap<String, String>()));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        String itemName = this.getItemNameBySlot(slot);
        if (itemName == null) {
            return;
        }
        switch (itemName) {
            case "previous_page": {
                this.handlePreviousPage(player);
                break;
            }
            case "next_page": {
                this.handleNextPage(player);
                break;
            }
            case "back": {
                this.handleBack(player);
            }
        }
    }

    private String getItemNameBySlot(int slot) {
        String[] items;
        for (String itemName : items = new String[]{"previous_page", "current_page", "next_page", "back"}) {
            GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, itemName);
            if (config == null || config.getSlot() != slot) continue;
            return itemName;
        }
        return null;
    }

    private void handlePreviousPage(Player player) {
        if (this.page > 0) {
            this.guiManager.openGui(player, new ConfigurableActivityLogsGui(this.guiManager, this.guiConfig, this.land, this.page - 1));
        }
    }

    private void handleNextPage(Player player) {
        if ((this.page + 1) * 45 < this.logs.size()) {
            this.guiManager.openGui(player, new ConfigurableActivityLogsGui(this.guiManager, this.guiConfig, this.land, this.page + 1));
        }
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

