/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Quest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableQuestsGui
implements LandGui {
    private static final String GUI_NAME = "quests_menu";
    private final GuiConfig guiConfig;
    private final List<Quest> quests;

    public ConfigurableQuestsGui(@NotNull GuiConfig guiConfig) {
        this.guiConfig = guiConfig;
        this.quests = this.generateSampleQuests();
    }

    private List<Quest> generateSampleQuests() {
        ArrayList<Quest> sampleQuests = new ArrayList<Quest>();
        sampleQuests.add(new Quest("first_land", "\u00a7a\u00a7lFirst Steps", "\u00a77Create your first land", Material.GRASS_BLOCK, Arrays.asList("\u00a77Create a land", "\u00a77Reward: \u00a76500 coins"), 500, true));
        sampleQuests.add(new Quest("upgrade_level_5", "\u00a7e\u00a7lGrowing Up", "\u00a77Reach level 5", Material.EXPERIENCE_BOTTLE, Arrays.asList("\u00a77Upgrade to level \u00a7e5", "\u00a77Progress: \u00a7e3\u00a77/\u00a7e5", "\u00a77Reward: \u00a761000 coins"), 1000, false));
        sampleQuests.add(new Quest("invite_members", "\u00a7b\u00a7lTeam Builder", "\u00a77Invite 3 co-owners", Material.PLAYER_HEAD, Arrays.asList("\u00a77Invite \u00a7b3 \u00a77members", "\u00a77Progress: \u00a7b1\u00a77/\u00a7b3", "\u00a77Reward: \u00a76750 coins"), 750, false));
        sampleQuests.add(new Quest("set_home", "\u00a7d\u00a7lHome Sweet Home", "\u00a77Set a home point", Material.RED_BED, Arrays.asList("\u00a77Set your home location", "\u00a77Reward: \u00a76250 coins"), 250, false));
        sampleQuests.add(new Quest("open_visits", "\u00a76\u00a7lWelcoming Host", "\u00a77Open your land to visits", Material.OAK_DOOR, Arrays.asList("\u00a77Enable public visits", "\u00a77Reward: \u00a76300 coins"), 300, false));
        return sampleQuests;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.displayQuests(inv);
        this.createItem(inv, "back");
        return inv;
    }

    private void displayQuests(@NotNull Inventory inv) {
        for (int i = 0; i < Math.min(this.quests.size(), 26); ++i) {
            Quest quest = this.quests.get(i);
            ItemStack item = new ItemStack(quest.material());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(quest.name());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                lore.add(quest.description());
                lore.add("");
                lore.addAll(quest.objectives());
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                if (quest.completed()) {
                    lore.add("");
                    lore.add("\u00a7a\u00a7l\u2714 COMPLETED");
                } else {
                    lore.add("");
                    lore.add("\u00a7e\u25b6 Click to track");
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.setItem(i, item);
        }
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(itemConfig.getName());
            meta.setLore(itemConfig.getLore(new HashMap<String, String>()));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        if (slot >= 0 && slot < Math.min(this.quests.size(), 26)) {
            Quest quest = this.quests.get(slot);
            if (!quest.completed()) {
                player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                player.sendMessage(quest.name());
                player.sendMessage(quest.description());
                player.sendMessage("");
                quest.objectives().forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            } else {
                player.sendMessage("\u00a7a\u2714 This quest is already completed!");
            }
            return;
        }
        String itemName = this.getItemNameBySlot(slot);
        if (itemName != null && itemName.equals("back")) {
            this.handleBack(player);
        }
    }

    private String getItemNameBySlot(int slot) {
        GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, "back");
        if (config != null && config.getSlot() == slot) {
            return "back";
        }
        return null;
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

