/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.libs.caffeine.cache;

import com.skynex.mylands.libs.caffeine.cache.Caffeine;
import org.checkerframework.checker.index.qual.NonNegative;

final class FrequencySketch<E> {
    static final long RESET_MASK = 0x7777777777777777L;
    static final long ONE_MASK = 0x1111111111111111L;
    int sampleSize;
    int blockMask;
    long[] table;
    int size;

    public void ensureCapacity(@NonNegative long maximumSize) {
        Caffeine.requireArgument(maximumSize >= 0L);
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[Math.max(Caffeine.ceilingPowerOfTwo(maximum), 8)];
        this.sampleSize = maximumSize == 0L ? 10 : 10 * maximum;
        this.blockMask = (this.table.length >>> 3) - 1;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    public boolean isNotInitialized() {
        return this.table == null;
    }

    public @NonNegative int frequency(E e) {
        if (this.isNotInitialized()) {
            return 0;
        }
        int[] count = new int[4];
        int blockHash = FrequencySketch.spread(e.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        for (int i = 0; i < 4; ++i) {
            int h2 = counterHash >>> (i << 3);
            int index = h2 >>> 1 & 0xF;
            int offset = h2 & 1;
            count[i] = (int)(this.table[block + offset + (i << 1)] >>> (index << 2) & 0xFL);
        }
        return Math.min(Math.min(count[0], count[1]), Math.min(count[2], count[3]));
    }

    public void increment(E e) {
        if (this.isNotInitialized()) {
            return;
        }
        int[] index = new int[8];
        int blockHash = FrequencySketch.spread(e.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        for (int i = 0; i < 4; ++i) {
            int h2 = counterHash >>> (i << 3);
            index[i] = h2 >>> 1 & 0xF;
            int offset = h2 & 1;
            index[i + 4] = block + offset + (i << 1);
        }
        boolean added = this.incrementAt(index[4], index[0]) | this.incrementAt(index[5], index[1]) | this.incrementAt(index[6], index[2]) | this.incrementAt(index[7], index[3]);
        if (added && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    static int spread(int x) {
        x ^= x >>> 17;
        x *= -312814405;
        x ^= x >>> 11;
        x *= -1404298415;
        x ^= x >>> 15;
        return x;
    }

    static int rehash(int x) {
        x *= 830770091;
        x ^= x >>> 14;
        return x;
    }

    boolean incrementAt(int i, int j) {
        int offset = j << 2;
        long mask = 15L << offset;
        if ((this.table[i] & mask) != mask) {
            int n = i;
            this.table[n] = this.table[n] + (1L << offset);
            return true;
        }
        return false;
    }

    void reset() {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.size = this.size - (count >>> 2) >>> 1;
    }
}

