/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.listeners;

import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.model.LandPermission;
import com.skynex.mylands.service.GradeService;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class LandListener
implements Listener {
    private final LandManager landManager;
    private final Map<UUID, Boolean> playerInFarmStatus = new ConcurrentHashMap<UUID, Boolean>();

    public LandListener(LandManager landManager) {
        this.landManager = landManager;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Boolean wasInFarm;
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Land land = this.landManager.getLandAtLocation(to);
        boolean isInFarm = land != null && land.hasAccess(playerId);
        if (isInFarm != (wasInFarm = this.playerInFarmStatus.getOrDefault(playerId, false))) {
            if (isInFarm && land != null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.landManager.getMessages().enterFarm()));
                String titleText = this.landManager.getMessages().get("enter_farm_title").replace("{name}", land.name());
                player.sendTitle(titleText, "", 10, 70, 20);
            } else {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.landManager.getMessages().leaveFarm()));
            }
            this.playerInFarmStatus.put(playerId, isInFarm);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Ageable ageable;
        BlockData blockData;
        Player player = event.getPlayer();
        Location location = event.getBlock().getLocation();
        Block block = event.getBlock();
        Land land = this.landManager.getLandAtLocation(location);
        if (land == null) {
            return;
        }
        GradeService gradeService = this.landManager.getGradeService();
        if (!land.ownerId().equals(player.getUniqueId()) && !gradeService.hasPermission(land.ownerId(), player.getUniqueId(), LandPermission.BUILD)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7c\u2716 You don't have permission to break blocks here!");
            return;
        }
        Material type = block.getType();
        if (this.isHarvestable(type) && (blockData = block.getBlockData()) instanceof Ageable && (ageable = (Ageable)blockData).getAge() == ageable.getMaximumAge()) {
            block.setType(Material.AIR);
            block.setType(type);
            ageable.setAge(0);
            block.setBlockData((BlockData)ageable);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Location location = event.getBlock().getLocation();
        Land land = this.landManager.getLandAtLocation(location);
        if (land == null) {
            return;
        }
        GradeService gradeService = this.landManager.getGradeService();
        if (!land.ownerId().equals(player.getUniqueId()) && !gradeService.hasPermission(land.ownerId(), player.getUniqueId(), LandPermission.BUILD)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7c\u2716 You don't have permission to place blocks here!");
            return;
        }
        if (this.landManager.hasAccessToLocation(player.getUniqueId(), location)) {
            return;
        }
        if (land != null) {
            event.setCancelled(true);
            player.sendMessage(this.landManager.getMessages().cannotPlaceOtherFarm());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Player player = event.getPlayer();
        Location location = event.getClickedBlock().getLocation();
        Land land = this.landManager.getLandAtLocation(location);
        if (land == null) {
            return;
        }
        GradeService gradeService = this.landManager.getGradeService();
        if (!land.ownerId().equals(player.getUniqueId()) && !gradeService.hasPermission(land.ownerId(), player.getUniqueId(), LandPermission.INTERACT)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7c\u2716 You don't have permission to interact here!");
        }
    }

    private boolean isHarvestable(Material material) {
        return material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS || material == Material.NETHER_WART;
    }
}

