/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public record QuestProgress(@NotNull UUID playerId, @NotNull String questId, int currentAmount, boolean completed, @NotNull Instant startedAt, Instant completedAt) {
    public static QuestProgress start(@NotNull UUID playerId, @NotNull String questId) {
        return new QuestProgress(playerId, questId, 0, false, Instant.now(), null);
    }

    public QuestProgress increment(int amount) {
        return new QuestProgress(this.playerId, this.questId, this.currentAmount + amount, this.completed, this.startedAt, this.completedAt);
    }

    public QuestProgress complete() {
        return new QuestProgress(this.playerId, this.questId, this.currentAmount, true, this.startedAt, Instant.now());
    }

    public int getProgressPercentage(int targetAmount) {
        if (targetAmount == 0) {
            return 100;
        }
        return Math.min(100, this.currentAmount * 100 / targetAmount);
    }

    public boolean isStartedToday() {
        LocalDate today = LocalDate.now();
        LocalDate startDate = this.startedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        return today.equals(startDate);
    }

    public boolean isCompletedToday() {
        if (this.completedAt == null) {
            return false;
        }
        LocalDate today = LocalDate.now();
        LocalDate completeDate = this.completedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        return today.equals(completeDate);
    }

    public boolean isExpired(boolean isDaily, boolean isWeekly) {
        if (!isDaily && !isWeekly) {
            return false;
        }
        LocalDate today = LocalDate.now();
        LocalDate startDate = this.startedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        if (isDaily) {
            return !today.equals(startDate);
        }
        if (isWeekly) {
            return today.minusDays(7L).isAfter(startDate);
        }
        return false;
    }
}

