/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service.jobs;

import com.skynex.mylands.service.jobs.JobsProvider;
import com.skynex.mylands.util.PluginLogger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class JobsRebornProvider
implements JobsProvider {
    private final Object jobsInstance = this.getJobsInstance();

    @Override
    @NotNull
    public String getName() {
        return "JobsReborn";
    }

    @Override
    public boolean isAvailable() {
        return this.jobsInstance != null;
    }

    private Object getJobsInstance() {
        try {
            Class<?> jobsClass = Class.forName("com.gamingmesh.jobs.Jobs");
            return jobsClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CompletableFuture<Integer> getJobLevel(@NotNull Player player, @NotNull String jobName) {
        if (!this.isAvailable()) {
            return CompletableFuture.completedFuture(0);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<?> jobsClass = Class.forName("com.gamingmesh.jobs.Jobs");
                Object job = jobsClass.getMethod("getJob", String.class).invoke(null, jobName);
                if (job == null) {
                    return 0;
                }
                Object playerManager = jobsClass.getMethod("getPlayerManager", new Class[0]).invoke(null, new Object[0]);
                Class<?> playerManagerClass = Class.forName("com.gamingmesh.jobs.PlayerManager");
                Object jobsPlayer = playerManagerClass.getMethod("getJobsPlayer", Player.class).invoke(playerManager, player);
                if (jobsPlayer == null) {
                    return 0;
                }
                Class<?> jobsPlayerClass = Class.forName("com.gamingmesh.jobs.container.JobsPlayer");
                Class<?> jobClass = Class.forName("com.gamingmesh.jobs.container.Job");
                Object progression = jobsPlayerClass.getMethod("getJobProgression", jobClass).invoke(jobsPlayer, job);
                if (progression == null) {
                    return 0;
                }
                Class<?> progressionClass = Class.forName("com.gamingmesh.jobs.container.JobProgression");
                return (Integer)progressionClass.getMethod("getLevel", new Class[0]).invoke(progression, new Object[0]);
            }
            catch (Exception e) {
                PluginLogger.error("Error getting job level from JobsReborn", e);
                return 0;
            }
        });
    }

    @Override
    public CompletableFuture<Optional<String>> getPlayerJobsString(@NotNull Player player) {
        if (!this.isAvailable()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<?> jobsClass = Class.forName("com.gamingmesh.jobs.Jobs");
                Object playerManager = jobsClass.getMethod("getPlayerManager", new Class[0]).invoke(null, new Object[0]);
                Class<?> playerManagerClass = Class.forName("com.gamingmesh.jobs.PlayerManager");
                Object jobsPlayer = playerManagerClass.getMethod("getJobsPlayer", Player.class).invoke(playerManager, player);
                if (jobsPlayer == null) {
                    return Optional.empty();
                }
                Class<?> jobsPlayerClass = Class.forName("com.gamingmesh.jobs.container.JobsPlayer");
                List progressions = (List)jobsPlayerClass.getMethod("getJobProgression", new Class[0]).invoke(jobsPlayer, new Object[0]);
                if (progressions == null || progressions.isEmpty()) {
                    return Optional.empty();
                }
                StringBuilder sb = new StringBuilder();
                Class<?> progressionClass = Class.forName("com.gamingmesh.jobs.container.JobProgression");
                Class<?> jobClass = Class.forName("com.gamingmesh.jobs.container.Job");
                for (Object progression : progressions) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    Object job = progressionClass.getMethod("getJob", new Class[0]).invoke(progression, new Object[0]);
                    String jobName = (String)jobClass.getMethod("getName", new Class[0]).invoke(job, new Object[0]);
                    Integer level = (Integer)progressionClass.getMethod("getLevel", new Class[0]).invoke(progression, new Object[0]);
                    sb.append(jobName).append(" (lvl ").append(level).append(")");
                }
                return Optional.of(sb.toString());
            }
            catch (Exception e) {
                PluginLogger.error("Error getting player jobs from JobsReborn", e);
                return Optional.empty();
            }
        });
    }

    @Override
    public boolean jobExists(@NotNull String jobName) {
        if (!this.isAvailable()) {
            return false;
        }
        try {
            Class<?> jobsClass = Class.forName("com.gamingmesh.jobs.Jobs");
            Object job = jobsClass.getMethod("getJob", String.class).invoke(null, jobName);
            return job != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void validateJobNames(@NotNull Iterable<String> jobNames) {
        if (!this.isAvailable()) {
            return;
        }
        for (String jobName : jobNames) {
            if (this.jobExists(jobName)) continue;
            PluginLogger.warn("Job '{}' referenced in config but not found in Jobs Reborn", jobName);
        }
    }
}

