/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.JailManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DelJailCommand
extends BaseCommand
implements TabCompleter {
    public DelJailCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.deljail")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/deljail <nom>");
            return true;
        }
        String jailName = args[0];
        JailManager jailManager = this.plugin.getJailManager();
        if (!jailManager.getJails().containsKey(jailName)) {
            this.msg.sendMessage(sender, "commands.deljail.not-found", this.msg.placeholder("jail", jailName));
            return true;
        }
        jailManager.deleteJail(jailName);
        this.msg.sendMessage(sender, "commands.deljail.deleted", this.msg.placeholder("jail", jailName));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getJailManager().getJails().keySet().stream().filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

