/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GamemodeCommand
extends BaseCommand {
    public GamemodeCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        if (!this.checkPermission(sender, "mycommands.gamemode")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/gamemode <mode> [player]");
            return true;
        }
        GameMode mode = this.parseGameMode(args[0]);
        if (mode == null) {
            this.msg.sendMessage(sender, "gamemode.invalid");
            return true;
        }
        if (args.length >= 2) {
            target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                this.msg.sendMessage(sender, "general.player-not-found");
                return true;
            }
        } else {
            target = this.getPlayer(sender);
            if (target == null) {
                return true;
            }
        }
        target.setGameMode(mode);
        if (target.equals((Object)sender)) {
            this.msg.sendMessage(sender, "gamemode.changed", this.msg.placeholder("mode", mode.name()));
        } else {
            this.msg.sendMessage(sender, "gamemode.changed-other", this.msg.placeholder("player", target.getName()), this.msg.placeholder("mode", mode.name()));
            this.msg.sendMessage((CommandSender)target, "gamemode.changed", this.msg.placeholder("mode", mode.name()));
        }
        return true;
    }

    private GameMode parseGameMode(String input) {
        switch (input.toLowerCase()) {
            case "0": 
            case "s": 
            case "survival": {
                return GameMode.SURVIVAL;
            }
            case "1": 
            case "c": 
            case "creative": {
                return GameMode.CREATIVE;
            }
            case "2": 
            case "a": 
            case "adventure": {
                return GameMode.ADVENTURE;
            }
            case "3": 
            case "sp": 
            case "spectator": {
                return GameMode.SPECTATOR;
            }
        }
        return null;
    }
}

