/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends BaseCommand {
    public GiveCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Material material;
        if (!this.checkPermission(sender, "mycommands.give")) {
            return true;
        }
        if (args.length < 2) {
            this.sendUsage(sender, "/give <player> <item> [amount]");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            this.msg.sendMessage(sender, "general.player-not-found");
            return true;
        }
        try {
            material = Material.valueOf((String)args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.msg.sendMessage(sender, "give.invalid-item");
            return true;
        }
        int amount = 1;
        if (args.length >= 3) {
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
        }
        ItemStack item = new ItemStack(material, amount);
        target.getInventory().addItem(new ItemStack[]{item});
        this.msg.sendMessage(sender, "give.given", this.msg.placeholder("player", target.getName()), this.msg.placeholder("item", material.name()), this.msg.placeholder("amount", String.valueOf(amount)));
        this.msg.sendMessage((CommandSender)target, "give.received", this.msg.placeholder("item", material.name()), this.msg.placeholder("amount", String.valueOf(amount)));
        return true;
    }
}

