/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.JailManager;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class JailsCommand
extends BaseCommand {
    public JailsCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.jails")) {
            return true;
        }
        JailManager jailManager = this.plugin.getJailManager();
        Map<String, Location> jails = jailManager.getJails();
        if (jails.isEmpty()) {
            this.msg.sendMessage(sender, "commands.jails.no-jails");
            return true;
        }
        this.msg.sendMessage(sender, "commands.jails.header", this.msg.placeholder("count", String.valueOf(jails.size())));
        for (Map.Entry<String, Location> entry : jails.entrySet()) {
            Location loc = entry.getValue();
            sender.sendMessage(this.msg.colorize("  &e\u2022 &f" + entry.getKey() + " &7(" + loc.getWorld().getName() + " " + (int)loc.getX() + " " + (int)loc.getY() + " " + (int)loc.getZ() + ")"));
        }
        int jailedCount = jailManager.getJailedPlayers().size();
        if (jailedCount > 0) {
            sender.sendMessage(this.msg.colorize("&7Joueurs emprisonn\u00e9s: &c" + jailedCount));
        }
        return true;
    }
}

