/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.AFKManager;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand
extends BaseCommand {
    public ListCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.list")) {
            return true;
        }
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        int total = players.size();
        int afkCount = 0;
        AFKManager afkManager = this.plugin.getAFKManager();
        for (Player p : players) {
            if (afkManager == null || !afkManager.isAFK(p.getUniqueId())) continue;
            ++afkCount;
        }
        int active = total - afkCount;
        this.msg.sendMessage(sender, "commands.list.header", this.msg.placeholder("online", String.valueOf(total)), this.msg.placeholder("max", String.valueOf(Bukkit.getMaxPlayers())), this.msg.placeholder("active", String.valueOf(active)), this.msg.placeholder("afk", String.valueOf(afkCount)));
        StringBuilder playerList = new StringBuilder();
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            if (this.dataManager.isVanished(p.getUniqueId()) && !sender.hasPermission("mycommands.vanish.see")) continue;
            Object displayName = p.getName();
            String nick = this.dataManager.getNickname(p.getUniqueId());
            if (nick != null) {
                displayName = nick + " &7(" + p.getName() + ")";
            }
            Object indicators = "";
            if (this.dataManager.isVanished(p.getUniqueId())) {
                indicators = (String)indicators + "&8[V] ";
            }
            if (afkManager != null && afkManager.isAFK(p.getUniqueId())) {
                indicators = (String)indicators + "&7[AFK] ";
            }
            playerList.append(this.msg.colorize((String)indicators + "&e" + (String)displayName));
            if (i >= players.size() - 1) continue;
            playerList.append(this.msg.colorize("&7, "));
        }
        sender.sendMessage(playerList.toString());
        this.msg.sendMessage(sender, "commands.list.footer");
        return true;
    }
}

