/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.Arrays;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MsgCommand
extends BaseCommand {
    public MsgCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.msg");
        if (player == null) {
            return true;
        }
        if (args.length < 2) {
            this.sendUsage(sender, "/msg <player> <message>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            this.msg.sendMessage((CommandSender)player, "general.player-not-found");
            return true;
        }
        if (target.equals((Object)player)) {
            this.msg.sendMessage((CommandSender)player, "messages.self");
            return true;
        }
        if (this.dataManager.isIgnoring(target.getUniqueId(), player.getUniqueId())) {
            this.msg.sendMessage((CommandSender)player, "messages.ignored-by");
            return true;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        this.msg.sendMessage((CommandSender)player, "messages.format-sender", this.msg.placeholder("receiver", target.getName()), this.msg.placeholder("message", message));
        this.msg.sendMessage((CommandSender)target, "messages.format-receiver", this.msg.placeholder("sender", player.getName()), this.msg.placeholder("message", message));
        this.dataManager.setLastMessager(player.getUniqueId(), target.getUniqueId());
        this.dataManager.setLastMessager(target.getUniqueId(), player.getUniqueId());
        for (Player online : this.plugin.getServer().getOnlinePlayers()) {
            if (!this.dataManager.hasSocialSpy(online.getUniqueId()) || online.equals((Object)player) || online.equals((Object)target)) continue;
            this.msg.sendMessage((CommandSender)online, "socialspy.format", this.msg.placeholder("sender", player.getName()), this.msg.placeholder("receiver", target.getName()), this.msg.placeholder("message", message));
        }
        if (this.statsManager != null) {
            this.statsManager.incrementMessagesSent(player);
        }
        if (this.plugin.getConfig().getBoolean("private-messages.sound.enabled", true)) {
            String soundName = this.plugin.getConfig().getString("private-messages.sound.type", "ENTITY_EXPERIENCE_ORB_PICKUP");
            try {
                target.playSound(target.getLocation(), Sound.valueOf((String)soundName), 1.0f, 1.0f);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }
}

