/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReplyCommand
extends BaseCommand {
    public ReplyCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.reply");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/reply <message>");
            return true;
        }
        UUID targetUUID = this.dataManager.getLastMessager(player.getUniqueId());
        if (targetUUID == null) {
            this.msg.sendMessage((CommandSender)player, "messages.no-reply");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(targetUUID);
        if (target == null) {
            this.msg.sendMessage((CommandSender)player, "general.player-not-found");
            return true;
        }
        if (this.dataManager.isIgnoring(target.getUniqueId(), player.getUniqueId())) {
            this.msg.sendMessage((CommandSender)player, "messages.ignored", this.msg.placeholder("player", target.getName()));
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        this.msg.sendMessage((CommandSender)player, "messages.format-sender", this.msg.placeholder("player", target.getName()), this.msg.placeholder("message", message));
        this.msg.sendMessage((CommandSender)target, "messages.format-receiver", this.msg.placeholder("player", player.getName()), this.msg.placeholder("message", message));
        for (Player online : this.plugin.getServer().getOnlinePlayers()) {
            if (!this.dataManager.hasSocialSpy(online.getUniqueId()) || online.equals((Object)player) || online.equals((Object)target)) continue;
            this.msg.sendMessage((CommandSender)online, "socialspy.format", this.msg.placeholder("sender", player.getName()), this.msg.placeholder("receiver", target.getName()), this.msg.placeholder("message", message));
        }
        if (this.statsManager != null) {
            this.statsManager.incrementMessagesSent(player);
        }
        return true;
    }
}

