/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportCommand
extends BaseCommand {
    public TeleportCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.tp");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/tp <player|x y z>");
            return true;
        }
        if (args.length >= 3) {
            try {
                double x = Double.parseDouble(args[0]);
                double y = Double.parseDouble(args[1]);
                double z = Double.parseDouble(args[2]);
                Location loc = new Location(player.getWorld(), x, y, z);
                player.teleport(loc);
                this.msg.sendMessage((CommandSender)player, "tp.teleported-to-coords", this.msg.placeholder("x", String.valueOf((int)x)), this.msg.placeholder("y", String.valueOf((int)y)), this.msg.placeholder("z", String.valueOf((int)z)));
            }
            catch (NumberFormatException e) {
                this.msg.sendMessage(sender, "general.invalid-usage");
            }
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            this.msg.sendMessage(sender, "general.player-not-found");
            return true;
        }
        player.teleport(target.getLocation());
        this.msg.sendMessage((CommandSender)player, "tp.teleported-to-player", this.msg.placeholder("player", target.getName()));
        return true;
    }
}

