/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TpaCommand
extends BaseCommand {
    public TpaCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.tpa");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/tpa <player>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            this.msg.sendMessage((CommandSender)player, "general.player-not-found");
            return true;
        }
        if (target.equals((Object)player)) {
            this.msg.sendMessage((CommandSender)player, "teleport.tpa.self");
            return true;
        }
        if (!this.checkEconomy(player, "tpa-request")) {
            return true;
        }
        this.dataManager.createTpaRequest(player.getUniqueId(), target.getUniqueId());
        this.msg.sendMessage((CommandSender)player, "teleport.tpa.request-sent", this.msg.placeholder("player", target.getName()));
        this.msg.sendMessage((CommandSender)target, "teleport.tpa.request-received", this.msg.placeholder("player", player.getName()));
        int timeout = this.plugin.getConfig().getInt("limits.tp-request-timeout", 60);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.dataManager.hasTpaRequest(player.getUniqueId(), target.getUniqueId())) {
                this.dataManager.removeTpaRequest(player.getUniqueId(), target.getUniqueId());
                this.msg.sendMessage((CommandSender)player, "teleport.tpa.request-expired");
            }
        }, (long)timeout * 20L);
        return true;
    }
}

