/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.gui;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.gui.StaticTeleportItem;
import fr.skynex.mycommands.managers.GUIConfig;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HomesGUI
implements Listener {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final GUIConfig guiConfig;
    private final Map<UUID, Inventory> activeGUIs = new HashMap<UUID, Inventory>();

    public HomesGUI(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.guiConfig = plugin.getGUIConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player) {
        if (!this.guiConfig.isHomesGUIEnabled()) {
            this.msg.sendMessage((CommandSender)player, "gui.disabled");
            return;
        }
        if (!player.hasPermission("mycommands.gui.homes")) {
            this.msg.sendMessage((CommandSender)player, "no-permission");
            return;
        }
        Map<String, Location> homes = this.plugin.getDataManager().getHomes(player.getUniqueId());
        int maxHomes = this.getMaxHomes(player);
        int size = this.calculateInventorySize(homes.size(), this.guiConfig.getHomesSizeConfig());
        HashMap<String, String> titlePlaceholders = new HashMap<String, String>();
        titlePlaceholders.put("count", String.valueOf(homes.size()));
        titlePlaceholders.put("max", maxHomes == Integer.MAX_VALUE ? "\u221e" : String.valueOf(maxHomes));
        titlePlaceholders.put("player", player.getName());
        String title = this.guiConfig.replacePlaceholders(this.guiConfig.getHomesTitle(), titlePlaceholders);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)title);
        int slot = 0;
        for (Map.Entry<String, Location> entry : homes.entrySet()) {
            if (slot >= size - 9) break;
            String homeName = entry.getKey();
            Location loc = entry.getValue();
            ItemStack item = this.createHomeItem(homeName, loc);
            inv.setItem(slot, item);
            ++slot;
        }
        if (this.guiConfig.isStaticHomesEnabled()) {
            List<StaticTeleportItem> staticHomes = this.guiConfig.getStaticHomes();
            for (StaticTeleportItem staticHome : staticHomes) {
                if (staticHome.hasPermission() && !player.hasPermission(staticHome.getPermission())) continue;
                inv.setItem(staticHome.getSlot(), staticHome.createItem());
            }
        }
        this.addControlButtons(inv, size, homes.size(), maxHomes);
        if (this.guiConfig.isHomesDecorationEnabled()) {
            this.fillEmptySlots(inv, this.guiConfig.getHomesDecorationMaterial(), this.guiConfig.getHomesDecorationName());
        }
        this.activeGUIs.put(player.getUniqueId(), inv);
        player.openInventory(inv);
        this.playSound(player, this.guiConfig.getOpenGUISound());
    }

    private ItemStack createHomeItem(String homeName, Location loc) {
        ItemStack item = new ItemStack(this.guiConfig.getHomeItemMaterial());
        ItemMeta meta = item.getItemMeta();
        HashMap<String, String> namePlaceholders = new HashMap<String, String>();
        namePlaceholders.put("home", homeName);
        meta.setDisplayName(this.guiConfig.replacePlaceholders(this.guiConfig.getHomeItemName(), namePlaceholders));
        HashMap<String, String> lorePlaceholders = new HashMap<String, String>();
        lorePlaceholders.put("home", homeName);
        lorePlaceholders.put("world", loc.getWorld() != null ? loc.getWorld().getName() : "unknown");
        lorePlaceholders.put("x", String.valueOf((int)loc.getX()));
        lorePlaceholders.put("y", String.valueOf((int)loc.getY()));
        lorePlaceholders.put("z", String.valueOf((int)loc.getZ()));
        ArrayList<String> lore = new ArrayList<String>(this.guiConfig.getHomeItemLore());
        meta.setLore(this.guiConfig.replacePlaceholders(lore, lorePlaceholders));
        item.setItemMeta(meta);
        return item;
    }

    private void addControlButtons(Inventory inv, int size, int currentHomes, int maxHomes) {
        int lastLineStart = size - 9;
        int addButtonSlot = lastLineStart + 0;
        int closeButtonSlot = lastLineStart + 8;
        if (currentHomes < maxHomes && this.guiConfig.isAddHomeButtonEnabled()) {
            ItemStack addButton = this.createAddHomeButton(currentHomes, maxHomes);
            inv.setItem(addButtonSlot, addButton);
        } else if (currentHomes >= maxHomes && this.guiConfig.isLimitReachedEnabled()) {
            ItemStack limitItem = this.createLimitReachedItem(maxHomes);
            inv.setItem(addButtonSlot, limitItem);
        }
        if (this.guiConfig.isHomesCloseButtonEnabled()) {
            ItemStack closeButton = this.createCloseButton();
            inv.setItem(closeButtonSlot, closeButton);
        }
    }

    private ItemStack createAddHomeButton(int current, int max) {
        ItemStack item = new ItemStack(this.guiConfig.getAddHomeButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.guiConfig.getAddHomeButtonName());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("current", String.valueOf(current));
        placeholders.put("max", max == Integer.MAX_VALUE ? "\u221e" : String.valueOf(max));
        ArrayList<String> lore = new ArrayList<String>(this.guiConfig.getAddHomeButtonLore());
        meta.setLore(this.guiConfig.replacePlaceholders(lore, placeholders));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createLimitReachedItem(int max) {
        ItemStack item = new ItemStack(this.guiConfig.getLimitReachedMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.guiConfig.getLimitReachedName());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("max", max == Integer.MAX_VALUE ? "\u221e" : String.valueOf(max));
        ArrayList<String> lore = new ArrayList<String>(this.guiConfig.getLimitReachedLore());
        meta.setLore(this.guiConfig.replacePlaceholders(lore, placeholders));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createCloseButton() {
        ItemStack item = new ItemStack(this.guiConfig.getHomesCloseButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.guiConfig.getHomesCloseButtonName());
        meta.setLore(this.guiConfig.getHomesCloseButtonLore());
        item.setItemMeta(meta);
        return item;
    }

    private void fillEmptySlots(Inventory inv, Material material, String name) {
        ItemStack filler = new ItemStack(material);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(name);
        filler.setItemMeta(meta);
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getType() != Material.AIR) continue;
            inv.setItem(i, filler);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        int lastLineStart;
        ItemStack clicked;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.activeGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        if (!event.getInventory().equals((Object)this.activeGUIs.get(player.getUniqueId()))) {
            return;
        }
        if (this.guiConfig.isPreventItemTake()) {
            event.setCancelled(true);
        }
        if ((clicked = event.getCurrentItem()) == null || clicked.getType() == Material.AIR) {
            return;
        }
        this.playSound(player, this.guiConfig.getClickItemSound());
        int size = event.getInventory().getSize();
        int addButtonSlot = lastLineStart = size - 9;
        int closeButtonSlot = lastLineStart + 8;
        if (event.getSlot() == closeButtonSlot && clicked.getType() == this.guiConfig.getHomesCloseButtonMaterial()) {
            player.closeInventory();
            return;
        }
        if (event.getSlot() == addButtonSlot && clicked.getType() == this.guiConfig.getAddHomeButtonMaterial()) {
            player.closeInventory();
            this.msg.sendMessage((CommandSender)player, "gui.homes.use-sethome");
            return;
        }
        if (event.getSlot() == addButtonSlot && clicked.getType() == this.guiConfig.getLimitReachedMaterial()) {
            this.msg.sendMessage((CommandSender)player, "gui.homes.limit-reached");
            this.playSound(player, this.guiConfig.getErrorSound());
            return;
        }
        if (this.guiConfig.isHomesDecorationEnabled() && clicked.getType() == this.guiConfig.getHomesDecorationMaterial()) {
            return;
        }
        if (this.guiConfig.isStaticHomesEnabled()) {
            List<StaticTeleportItem> staticHomes = this.guiConfig.getStaticHomes();
            for (StaticTeleportItem staticHome : staticHomes) {
                if (event.getSlot() != staticHome.getSlot() || !staticHome.isEnabled()) continue;
                if (staticHome.hasPermission() && !player.hasPermission(staticHome.getPermission())) {
                    this.msg.sendMessage((CommandSender)player, "no-permission");
                    this.playSound(player, this.guiConfig.getErrorSound());
                    return;
                }
                if (staticHome.hasValidLocation()) {
                    if (this.guiConfig.isCloseAfterTeleport()) {
                        player.closeInventory();
                    }
                    player.teleport(staticHome.getLocation());
                    this.playSound(player, this.guiConfig.getTeleportSound());
                }
                return;
            }
        }
        if (clicked.getType() == this.guiConfig.getHomeItemMaterial()) {
            String homeName = this.extractHomeName(clicked);
            if (homeName == null) {
                return;
            }
            if (event.isLeftClick()) {
                if (this.guiConfig.isCloseAfterTeleport()) {
                    player.closeInventory();
                }
                player.performCommand("home " + homeName);
                this.playSound(player, this.guiConfig.getTeleportSound());
            } else if (event.isRightClick()) {
                player.performCommand("delhome " + homeName);
                if (this.guiConfig.isRefreshAfterDelete()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        if (player.isOnline()) {
                            this.open(player);
                        }
                    }, 2L);
                } else {
                    player.closeInventory();
                }
            }
        }
    }

    private String extractHomeName(ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            return null;
        }
        String displayName = meta.getDisplayName();
        return ChatColor.stripColor((String)displayName);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.activeGUIs.remove(player.getUniqueId());
    }

    private int calculateInventorySize(int items, String sizeConfig) {
        if (sizeConfig.equalsIgnoreCase("auto")) {
            int neededSlots = items + 9;
            if (this.guiConfig.isStaticHomesEnabled()) {
                List<StaticTeleportItem> staticHomes = this.guiConfig.getStaticHomes();
                for (StaticTeleportItem staticHome : staticHomes) {
                    int requiredSlots;
                    if (!staticHome.isEnabled() || (requiredSlots = staticHome.getSlot() + 1) <= neededSlots) continue;
                    neededSlots = requiredSlots;
                }
            }
            int rows = (int)Math.ceil((double)neededSlots / 9.0);
            return Math.min(rows * 9, 54);
        }
        try {
            int size = Integer.parseInt(sizeConfig);
            size = (int)Math.ceil((double)size / 9.0) * 9;
            return Math.max(9, Math.min(size, 54));
        }
        catch (NumberFormatException e) {
            return 27;
        }
    }

    private int getMaxHomes(Player player) {
        if (player.hasPermission("mycommands.sethome.unlimited")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 100; i >= 1; --i) {
            if (!player.hasPermission("mycommands.sethome." + i)) continue;
            return i;
        }
        return this.plugin.getConfig().getInt("limits.max-homes", 3);
    }

    private void playSound(Player player, Sound sound) {
        if (!this.guiConfig.isSoundEnabled()) {
            return;
        }
        try {
            player.playSound(player.getLocation(), sound, this.guiConfig.getSoundVolume(), this.guiConfig.getSoundPitch());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

