/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.integrations;

import fr.skynex.mycommands.MyCommands;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultIntegration {
    private final MyCommands plugin;
    private Economy economy;
    private boolean enabled;

    public VaultIntegration(MyCommands plugin) {
        this.plugin = plugin;
        this.enabled = false;
    }

    public boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("Vault n'est pas install\u00e9 ! L'\u00e9conomie sera d\u00e9sactiv\u00e9e.");
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.plugin.getLogger().warning("Aucun plugin d'\u00e9conomie d\u00e9tect\u00e9 ! Installez EssentialsX, CMI, ou autre.");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        this.enabled = true;
        this.plugin.getLogger().info("\u00c9conomie activ\u00e9e avec succ\u00e8s ! (" + this.economy.getName() + ")");
        return true;
    }

    public boolean isEnabled() {
        return this.enabled && this.economy != null;
    }

    public boolean isEconomyAvailable() {
        return this.isEnabled();
    }

    public double getBalance(Player player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public boolean has(Player player, double amount) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public boolean withdraw(Player player, double amount) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!this.has(player, amount)) {
            return false;
        }
        return this.economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public boolean deposit(Player player, double amount) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.economy.depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.format("%.2f", amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrencyName() {
        if (!this.isEnabled()) {
            return "coins";
        }
        return this.economy.currencyNameSingular();
    }

    public String getCurrencyNamePlural() {
        if (!this.isEnabled()) {
            return "coins";
        }
        return this.economy.currencyNamePlural();
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

