/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.listeners;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.AFKManager;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JoinQuitListener
implements Listener {
    private final MyCommands plugin;
    private final DataManager dataManager;
    private final MessageManager msg;
    private final AFKManager afkManager;

    public JoinQuitListener(MyCommands plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.msg = plugin.getMessageManager();
        this.afkManager = plugin.getAFKManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Location spawn;
        boolean isFirstJoin;
        Player player = event.getPlayer();
        this.dataManager.loadPlayerData(player.getUniqueId());
        if (this.dataManager.hasGodMode(player.getUniqueId())) {
            player.setInvulnerable(true);
        }
        if (this.afkManager != null) {
            this.afkManager.loadPlayer(player.getUniqueId());
        }
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.enabled", true)) {
            return;
        }
        boolean bl = isFirstJoin = !player.hasPlayedBefore();
        if (this.plugin.getConfig().getBoolean("join-quit-messages.override-default", true)) {
            event.setJoinMessage(null);
        }
        if (isFirstJoin) {
            message = this.plugin.getConfig().getString("join-quit-messages.first-join", "&a&l+ &e{player} &7a rejoint le serveur pour la premi\u00e8re fois ! &a&l+");
            message = this.formatMessage(message, player);
            Bukkit.broadcastMessage((String)this.msg.colorize(message));
        } else {
            message = this.plugin.getConfig().getString("join-quit-messages.join", "&e{player} &7a rejoint le serveur &8[&a{online}&8/&a{max}&8]");
            message = this.formatMessage(message, player);
            Bukkit.broadcastMessage((String)this.msg.colorize(message));
        }
        if (this.plugin.getConfig().getBoolean("join-quit-messages.welcome-message.enabled", false)) {
            this.sendWelcomeMessage(player);
        }
        if (isFirstJoin && this.plugin.getConfig().getBoolean("spawn.teleport-on-first-join", true) && (spawn = this.dataManager.getSpawn()) != null) {
            player.teleport(spawn);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.afkManager != null) {
            this.afkManager.removePlayer(player.getUniqueId());
        }
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.enabled", true)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("join-quit-messages.override-default", true)) {
            event.setQuitMessage(null);
        }
        String message = this.plugin.getConfig().getString("join-quit-messages.quit", "&e{player} &7a quitt\u00e9 le serveur &8[&a{online}&8/&a{max}&8]");
        message = this.formatMessage(message, player);
        Bukkit.broadcastMessage((String)this.msg.colorize(message));
    }

    private String formatMessage(String message, Player player) {
        int online = Bukkit.getOnlinePlayers().size();
        int max = Bukkit.getMaxPlayers();
        return message.replace("{player}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{online}", String.valueOf(online)).replace("{max}", String.valueOf(max));
    }

    private void sendWelcomeMessage(Player player) {
        int delay = this.plugin.getConfig().getInt("join-quit-messages.welcome-message.delay", 20);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                List lines = this.plugin.getConfig().getStringList("join-quit-messages.welcome-message.lines");
                for (String line : lines) {
                    line = this.formatMessage(line, player);
                    player.sendMessage(this.msg.colorize(line));
                }
            }
        }, (long)delay);
    }
}

