/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.storage;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.storage.StorageProvider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements StorageProvider {
    private final MyCommands plugin;
    private final File dataFile;
    private FileConfiguration data;

    public YamlStorage(MyCommands plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.initialize();
    }

    @Override
    public void initialize() {
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create data.yml: " + e.getMessage());
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void save() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save data.yml: " + e.getMessage());
        }
    }

    public void reload() {
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.data.getConfigurationSection(path);
    }

    @Override
    public Location getHome(UUID uuid, String homeName) {
        String path = "homes." + String.valueOf(uuid) + "." + homeName;
        return this.getLocation(path);
    }

    @Override
    public void setHome(UUID uuid, String homeName, Location location) {
        String path = "homes." + String.valueOf(uuid) + "." + homeName;
        this.setLocation(path, location);
        this.save();
    }

    @Override
    public void deleteHome(UUID uuid, String homeName) {
        String path = "homes." + String.valueOf(uuid) + "." + homeName;
        this.data.set(path, null);
        this.save();
    }

    @Override
    public Map<String, Location> getAllHomes(UUID uuid) {
        HashMap<String, Location> homes = new HashMap<String, Location>();
        String basePath = "homes." + String.valueOf(uuid);
        ConfigurationSection section = this.data.getConfigurationSection(basePath);
        if (section == null) {
            return homes;
        }
        for (String homeName : section.getKeys(false)) {
            Location loc = this.getLocation(basePath + "." + homeName);
            if (loc == null) continue;
            homes.put(homeName, loc);
        }
        return homes;
    }

    @Override
    public boolean homeExists(UUID uuid, String homeName) {
        return this.data.contains("homes." + String.valueOf(uuid) + "." + homeName);
    }

    @Override
    public int getHomesCount(UUID uuid) {
        ConfigurationSection section = this.data.getConfigurationSection("homes." + String.valueOf(uuid));
        return section != null ? section.getKeys(false).size() : 0;
    }

    @Override
    public Location getWarp(String warpName) {
        return this.getLocation("warps." + warpName);
    }

    @Override
    public void setWarp(String warpName, Location location) {
        this.setLocation("warps." + warpName, location);
        this.save();
    }

    @Override
    public void deleteWarp(String warpName) {
        this.data.set("warps." + warpName, null);
        this.save();
    }

    @Override
    public Map<String, Location> getAllWarps() {
        HashMap<String, Location> warps = new HashMap<String, Location>();
        ConfigurationSection section = this.data.getConfigurationSection("warps");
        if (section == null) {
            return warps;
        }
        for (String warpName : section.getKeys(false)) {
            Location loc = this.getLocation("warps." + warpName);
            if (loc == null) continue;
            warps.put(warpName, loc);
        }
        return warps;
    }

    @Override
    public boolean warpExists(String warpName) {
        return this.data.contains("warps." + warpName);
    }

    @Override
    public Location getSpawn() {
        return this.getLocation("spawn");
    }

    @Override
    public void setSpawn(Location location) {
        this.setLocation("spawn", location);
        this.save();
    }

    @Override
    public void setVanish(UUID uuid, boolean vanished) {
        this.data.set("vanish." + String.valueOf(uuid), (Object)vanished);
        this.save();
    }

    @Override
    public boolean isVanished(UUID uuid) {
        return this.data.getBoolean("vanish." + String.valueOf(uuid), false);
    }

    @Override
    public void setFreeze(UUID uuid, boolean frozen) {
        this.data.set("freeze." + String.valueOf(uuid), (Object)frozen);
        this.save();
    }

    @Override
    public boolean isFrozen(UUID uuid) {
        return this.data.getBoolean("freeze." + String.valueOf(uuid), false);
    }

    @Override
    public void setGodMode(UUID uuid, boolean enabled) {
        this.data.set("godmode." + String.valueOf(uuid), (Object)enabled);
        this.save();
    }

    @Override
    public boolean hasGodMode(UUID uuid) {
        return this.data.getBoolean("godmode." + String.valueOf(uuid), false);
    }

    @Override
    public void setSocialSpy(UUID uuid, boolean enabled) {
        this.data.set("socialspy." + String.valueOf(uuid), (Object)enabled);
        this.save();
    }

    @Override
    public boolean hasSocialSpy(UUID uuid) {
        return this.data.getBoolean("socialspy." + String.valueOf(uuid), false);
    }

    @Override
    public void addIgnore(UUID player, UUID target) {
        List ignored = this.data.getStringList("ignore." + String.valueOf(player));
        if (!ignored.contains(target.toString())) {
            ignored.add(target.toString());
            this.data.set("ignore." + String.valueOf(player), (Object)ignored);
            this.save();
        }
    }

    @Override
    public void removeIgnore(UUID player, UUID target) {
        List ignored = this.data.getStringList("ignore." + String.valueOf(player));
        if (ignored.remove(target.toString())) {
            this.data.set("ignore." + String.valueOf(player), (Object)ignored);
            this.save();
        }
    }

    @Override
    public Set<UUID> getIgnoredPlayers(UUID player) {
        HashSet<UUID> ignored = new HashSet<UUID>();
        List list = this.data.getStringList("ignore." + String.valueOf(player));
        for (String uuidStr : list) {
            try {
                ignored.add(UUID.fromString(uuidStr));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ignored;
    }

    @Override
    public boolean isIgnoring(UUID player, UUID target) {
        List ignored = this.data.getStringList("ignore." + String.valueOf(player));
        return ignored.contains(target.toString());
    }

    @Override
    public void setNickname(UUID uuid, String nickname) {
        this.data.set("nicknames." + String.valueOf(uuid), (Object)nickname);
        this.save();
    }

    @Override
    public String getNickname(UUID uuid) {
        return this.data.getString("nicknames." + String.valueOf(uuid));
    }

    @Override
    public void removeNickname(UUID uuid) {
        this.data.set("nicknames." + String.valueOf(uuid), null);
        this.save();
    }

    @Override
    public boolean hasNickname(UUID uuid) {
        return this.data.contains("nicknames." + String.valueOf(uuid));
    }

    @Override
    public Set<UUID> getAllPlayerUUIDs() {
        ConfigurationSection vanishSection;
        ConfigurationSection nicknamesSection;
        HashSet<UUID> uuids = new HashSet<UUID>();
        ConfigurationSection homesSection = this.data.getConfigurationSection("homes");
        if (homesSection != null) {
            for (Object uuidStr : homesSection.getKeys(false)) {
                try {
                    uuids.add(UUID.fromString((String)uuidStr));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((nicknamesSection = this.data.getConfigurationSection("nicknames")) != null) {
            for (String uuidStr : nicknamesSection.getKeys(false)) {
                try {
                    uuids.add(UUID.fromString(uuidStr));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((vanishSection = this.data.getConfigurationSection("vanish")) != null) {
            for (String uuidStr : vanishSection.getKeys(false)) {
                try {
                    uuids.add(UUID.fromString(uuidStr));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return uuids;
    }

    private Location getLocation(String path) {
        if (!this.data.contains(path + ".world")) {
            return null;
        }
        String worldName = this.data.getString(path + ".world");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        double x = this.data.getDouble(path + ".x");
        double y = this.data.getDouble(path + ".y");
        double z = this.data.getDouble(path + ".z");
        float yaw = (float)this.data.getDouble(path + ".yaw", 0.0);
        float pitch = (float)this.data.getDouble(path + ".pitch", 0.0);
        return new Location(world, x, y, z, yaw, pitch);
    }

    private void setLocation(String path, Location location) {
        this.data.set(path + ".world", (Object)location.getWorld().getName());
        this.data.set(path + ".x", (Object)location.getX());
        this.data.set(path + ".y", (Object)location.getY());
        this.data.set(path + ".z", (Object)location.getZ());
        this.data.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.data.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
    }

    @Override
    public String getType() {
        return "yaml";
    }

    @Override
    public void close() {
        this.save();
    }
}

