/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;

public class MessageFormatter {
    public static void sendBoxedMessage(Player player, String title, Map<String, String> info, String footer) {
        String line = "\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
        player.sendMessage(line);
        player.sendMessage("  \u00a76\u00a7l" + title);
        player.sendMessage(line);
        player.sendMessage("");
        for (Map.Entry<String, String> entry : info.entrySet()) {
            player.sendMessage(" \u00a7e" + entry.getKey() + ": \u00a7f" + entry.getValue());
        }
        if (footer != null && !footer.isEmpty()) {
            player.sendMessage("");
            player.sendMessage(" \u00a77\u25b8 \u00a7f" + footer);
        }
        player.sendMessage("");
        player.sendMessage(line);
    }

    public static TextComponent createButton(String text, String command, String hoverText) {
        TextComponent button = new TextComponent(text);
        if (hoverText != null) {
            button.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
        }
        if (command != null) {
            button.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        }
        return button;
    }

    public static TextComponent createSuggestButton(String text, String command, String hoverText) {
        TextComponent button = new TextComponent(text);
        if (hoverText != null) {
            button.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
        }
        if (command != null) {
            button.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
        }
        return button;
    }

    public static void sendHomeCreatedMessage(Player player, String homeName) {
        TextComponent message = new TextComponent("\u00a7a\u00a7l\u2713 \u00a7fHome \u00a7e'" + homeName + "' \u00a7fcr\u00e9\u00e9 ! ");
        TextComponent tpButton = MessageFormatter.createButton("\u00a77[\u00a7a\u25b6 T\u00e9l\u00e9porter\u00a77]", "/home " + homeName, "\u00a7aCliquez pour vous t\u00e9l\u00e9porter");
        TextComponent delButton = MessageFormatter.createSuggestButton(" \u00a77[\u00a7c\u2717 Supprimer\u00a77]", "/delhome " + homeName, "\u00a7cCliquez pour pr\u00e9-remplir la commande");
        message.addExtra((BaseComponent)tpButton);
        message.addExtra((BaseComponent)delButton);
        player.spigot().sendMessage((BaseComponent)message);
    }

    public static void sendWarpCreatedMessage(Player player, String warpName) {
        TextComponent message = new TextComponent("\u00a7a\u00a7l\u2713 \u00a7fWarp \u00a7e'" + warpName + "' \u00a7fcr\u00e9\u00e9 ! ");
        TextComponent tpButton = MessageFormatter.createButton("\u00a77[\u00a7a\u25b6 T\u00e9l\u00e9porter\u00a77]", "/warp " + warpName, "\u00a7aCliquez pour vous t\u00e9l\u00e9porter");
        TextComponent delButton = MessageFormatter.createSuggestButton(" \u00a77[\u00a7c\u2717 Supprimer\u00a77]", "/delwarp " + warpName, "\u00a7cSupprimer ce warp");
        message.addExtra((BaseComponent)tpButton);
        message.addExtra((BaseComponent)delButton);
        player.spigot().sendMessage((BaseComponent)message);
    }

    public static void sendHomesList(Player player, List<String> homes) {
        player.sendMessage("\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("  \u00a76\u00a7lVOS HOMES \u00a77(" + homes.size() + ")");
        player.sendMessage("\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("");
        for (String home : homes) {
            TextComponent line = new TextComponent(" \u00a7e\u2022 \u00a7f" + home + " ");
            TextComponent tpBtn = MessageFormatter.createButton("\u00a77[\u00a7aTP\u00a77]", "/home " + home, "\u00a7aT\u00e9l\u00e9porter");
            TextComponent delBtn = MessageFormatter.createButton(" \u00a77[\u00a7c\u2717\u00a77]", "/delhome " + home, "\u00a7cSupprimer");
            line.addExtra((BaseComponent)tpBtn);
            line.addExtra((BaseComponent)delBtn);
            player.spigot().sendMessage((BaseComponent)line);
        }
        player.sendMessage("");
        player.sendMessage("\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    public static void sendActionBar(Player player, String message) {
        TextComponent component = new TextComponent(MessageFormatter.colorize(message));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)component);
    }

    public static String createProgressBar(int current, int max, int width) {
        if (max == 0) {
            return "\u00a77[" + "\u2591".repeat(width) + "\u00a77] 0%";
        }
        int filled = (int)((double)current / (double)max * (double)width);
        int empty = width - filled;
        filled = Math.max(0, Math.min(width, filled));
        empty = Math.max(0, Math.min(width, empty));
        String bar = "\u00a7a" + "\u2588".repeat(filled) + "\u00a77" + "\u2591".repeat(empty);
        int percent = (int)((double)current / (double)max * 100.0);
        return String.format("\u00a77[%s\u00a77] \u00a7f%d%%", bar, percent);
    }

    public static String createProgressBarWithNumbers(int current, int max, int width) {
        String bar = MessageFormatter.createProgressBar(current, max, width);
        return String.format("%s \u00a77(\u00a7f%d\u00a77/\u00a7f%d\u00a77)", bar, current, max);
    }

    private static String colorize(String message) {
        return message.replace("&", "\u00a7");
    }

    public static String stripColor(String message) {
        return message.replaceAll("\u00a7[0-9a-fk-or]", "");
    }
}

