/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.storage.YamlStorage;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MigrationTool {
    private final MyCommands plugin;
    private final DataManager dataManager;

    public MigrationTool(MyCommands plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
    }

    public CompletableFuture<MigrationResult> migrateYamlToMySQL(CommandSender sender) {
        return CompletableFuture.supplyAsync(() -> {
            MigrationResult result = new MigrationResult();
            try {
                this.sendMessage(sender, "&e[Migration] D\u00e9marrage de la migration YAML \u2192 MySQL...");
                if (!this.plugin.getConfig().getString("storage.type", "yaml").equals("mysql")) {
                    result.success = false;
                    result.error = "MySQL n'est pas configur\u00e9 dans config.yml";
                    return result;
                }
                YamlStorage yamlStorage = new YamlStorage(this.plugin);
                this.sendMessage(sender, "&e[Migration] Chargement des donn\u00e9es YAML...");
                Location spawn = yamlStorage.getSpawn();
                if (spawn != null) {
                    this.dataManager.setSpawn(spawn);
                    result.spawnMigrated = true;
                    this.sendMessage(sender, "&a[Migration] \u2713 Spawn migr\u00e9");
                }
                Map<String, Location> warps = yamlStorage.getAllWarps();
                for (Map.Entry<String, Location> entry : warps.entrySet()) {
                    this.dataManager.setWarp(entry.getKey(), entry.getValue());
                    ++result.warpsMigrated;
                }
                this.sendMessage(sender, "&a[Migration] \u2713 " + result.warpsMigrated + " warps migr\u00e9s");
                this.sendMessage(sender, "&e[Migration] Migration des homes...");
                ConfigurationSection homesSection = yamlStorage.getConfigurationSection("homes");
                if (homesSection != null) {
                    for (String uuidStr : homesSection.getKeys(false)) {
                        try {
                            UUID uuid = UUID.fromString(uuidStr);
                            Map<String, Location> playerHomes = yamlStorage.getAllHomes(uuid);
                            for (Map.Entry<String, Location> homeEntry : playerHomes.entrySet()) {
                                this.dataManager.setHome(uuid, homeEntry.getKey(), homeEntry.getValue());
                                ++result.homesMigrated;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.sendMessage(sender, "&c[Migration] UUID invalide ignor\u00e9: " + uuidStr);
                        }
                    }
                }
                this.sendMessage(sender, "&a[Migration] \u2713 " + result.homesMigrated + " homes migr\u00e9s");
                result.success = true;
                this.sendMessage(sender, "&a&l[Migration] \u2713\u2713\u2713 Migration termin\u00e9e avec succ\u00e8s ! \u2713\u2713\u2713");
                this.sendMessage(sender, "&eVous pouvez maintenant supprimer le fichier data.yml si tout fonctionne.");
            }
            catch (Exception e) {
                result.success = false;
                result.error = e.getMessage();
                this.sendMessage(sender, "&c&l[Migration] \u2717 Erreur lors de la migration !");
                this.sendMessage(sender, "&c" + e.getMessage());
                e.printStackTrace();
            }
            return result;
        });
    }

    public CompletableFuture<MigrationResult> migrateMySQLToYaml(CommandSender sender) {
        return CompletableFuture.supplyAsync(() -> {
            MigrationResult result = new MigrationResult();
            try {
                this.sendMessage(sender, "&e[Migration] D\u00e9marrage de la migration MySQL \u2192 YAML...");
                YamlStorage yamlStorage = new YamlStorage(this.plugin);
                this.sendMessage(sender, "&e[Migration] R\u00e9cup\u00e9ration des donn\u00e9es MySQL...");
                Location spawn = this.dataManager.getSpawn();
                if (spawn != null) {
                    yamlStorage.setSpawn(spawn);
                    result.spawnMigrated = true;
                    this.sendMessage(sender, "&a[Migration] \u2713 Spawn migr\u00e9");
                }
                Map<String, Location> warps = this.dataManager.getWarps();
                for (Map.Entry<String, Location> entry : warps.entrySet()) {
                    yamlStorage.setWarp(entry.getKey(), entry.getValue());
                    ++result.warpsMigrated;
                }
                this.sendMessage(sender, "&a[Migration] \u2713 " + result.warpsMigrated + " warps migr\u00e9s");
                this.sendMessage(sender, "&e[Migration] ! Homes non migr\u00e9s (n\u00e9cessite m\u00e9thode getAllPlayers)");
                result.success = true;
                this.sendMessage(sender, "&a&l[Migration] \u2713\u2713\u2713 Migration termin\u00e9e avec succ\u00e8s ! \u2713\u2713\u2713");
            }
            catch (Exception e) {
                result.success = false;
                result.error = e.getMessage();
                this.sendMessage(sender, "&c&l[Migration] \u2717 Erreur lors de la migration !");
                this.sendMessage(sender, "&c" + e.getMessage());
                e.printStackTrace();
            }
            return result;
        });
    }

    public boolean needsMigration() {
        String currentType = this.plugin.getConfig().getString("storage.type", "yaml");
        if (currentType.equals("mysql")) {
            YamlStorage yamlStorage = new YamlStorage(this.plugin);
            return yamlStorage.getSpawn() != null || !yamlStorage.getAllWarps().isEmpty();
        }
        return false;
    }

    private void sendMessage(CommandSender sender, String message) {
        if (sender != null) {
            sender.sendMessage(this.plugin.getMessageManager().colorize(message));
        }
        Bukkit.getLogger().info(message.replaceAll("&[0-9a-fk-or]", ""));
    }

    public static class MigrationResult {
        public boolean success = false;
        public String error = null;
        public boolean spawnMigrated = false;
        public int warpsMigrated = 0;
        public int homesMigrated = 0;
        public int ignoredMigrated = 0;

        public String getSummary() {
            if (!this.success) {
                return "Migration \u00e9chou\u00e9e: " + this.error;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Migration r\u00e9ussie:\n");
            if (this.spawnMigrated) {
                sb.append("- Spawn migr\u00e9\n");
            }
            sb.append("- ").append(this.warpsMigrated).append(" warps migr\u00e9s\n");
            sb.append("- ").append(this.homesMigrated).append(" homes migr\u00e9s\n");
            if (this.ignoredMigrated > 0) {
                sb.append("- ").append(this.ignoredMigrated).append(" relations d'ignorance migr\u00e9es");
            }
            return sb.toString();
        }
    }
}

