/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.audit;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class AuditLogger {
    private final MyEconomy plugin;
    private final List<AuditEntry> auditLog;
    private File auditFile;
    private FileConfiguration auditConfig;
    private static final int MAX_LOG_SIZE = 10000;

    public AuditLogger(MyEconomy plugin) {
        this.plugin = plugin;
        this.auditLog = new ArrayList<AuditEntry>();
        this.setupAuditFile();
        this.startAutoSave();
    }

    private void setupAuditFile() {
        this.auditFile = new File(this.plugin.getDataFolder(), "audit.log");
        if (!this.auditFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.auditFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Unable to create audit.log");
            }
        }
        this.auditConfig = YamlConfiguration.loadConfiguration((File)this.auditFile);
    }

    public void logTransaction(String type, UUID playerId, UUID targetId, double amount, String details) {
        AuditEntry entry = new AuditEntry(System.currentTimeMillis(), type, playerId, targetId, amount, details);
        this.auditLog.add(entry);
        if (this.auditLog.size() > 10000) {
            this.auditLog.remove(0);
        }
        if (this.auditLog.size() % 100 == 0) {
            this.saveAuditLog();
        }
    }

    public void logAdminAction(String action, UUID adminId, UUID targetId, double amount, String details) {
        this.logTransaction("ADMIN_" + action, adminId, targetId, amount, details);
    }

    public void logLargeTransaction(UUID playerId, UUID targetId, double amount, String details) {
        this.logTransaction("LARGE_TRANSACTION", playerId, targetId, amount, details);
    }

    public void logSuspiciousActivity(UUID playerId, String activity, String details) {
        this.logTransaction("SUSPICIOUS", playerId, null, 0.0, activity + ": " + details);
        this.plugin.getLogger().warning("Suspicious activity detected: " + activity + " - Player: " + String.valueOf(playerId));
    }

    public List<AuditEntry> getAuditLog(UUID playerId, long startTime, long endTime) {
        ArrayList<AuditEntry> result = new ArrayList<AuditEntry>();
        for (AuditEntry entry : this.auditLog) {
            if (entry.getTimestamp() < startTime || entry.getTimestamp() > endTime || playerId != null && !entry.getPlayerId().equals(playerId) && (entry.getTargetId() == null || !entry.getTargetId().equals(playerId))) continue;
            result.add(entry);
        }
        return result;
    }

    private void startAutoSave() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.saveAuditLog(), 0L, 6000L);
    }

    private void saveAuditLog() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this.auditLog.size(); ++i) {
                AuditEntry entry = this.auditLog.get(i);
                String path = "entries." + i;
                this.auditConfig.set(path + ".timestamp", (Object)entry.getTimestamp());
                this.auditConfig.set(path + ".type", (Object)entry.getType());
                this.auditConfig.set(path + ".playerId", (Object)entry.getPlayerId().toString());
                if (entry.getTargetId() != null) {
                    this.auditConfig.set(path + ".targetId", (Object)entry.getTargetId().toString());
                }
                this.auditConfig.set(path + ".amount", (Object)entry.getAmount());
                this.auditConfig.set(path + ".details", (Object)entry.getDetails());
                this.auditConfig.set(path + ".date", (Object)sdf.format(new Date(entry.getTimestamp())));
            }
            this.auditConfig.save(this.auditFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to save audit.log");
        }
    }

    public static class AuditEntry {
        private final long timestamp;
        private final String type;
        private final UUID playerId;
        private final UUID targetId;
        private final double amount;
        private final String details;

        public AuditEntry(long timestamp, String type, UUID playerId, UUID targetId, double amount, String details) {
            this.timestamp = timestamp;
            this.type = type;
            this.playerId = playerId;
            this.targetId = targetId;
            this.amount = amount;
            this.details = details;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getType() {
            return this.type;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public UUID getTargetId() {
            return this.targetId;
        }

        public double getAmount() {
            return this.amount;
        }

        public String getDetails() {
            return this.details;
        }
    }
}

