/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.backup;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BackupManager {
    private final MyEconomy plugin;
    private BukkitTask backupTask;

    public BackupManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.startAutoBackup();
    }

    private void startAutoBackup() {
        if (!this.plugin.getConfigManager().isBackupEnabled()) {
            return;
        }
        int intervalHours = this.plugin.getConfigManager().getBackupInterval();
        this.backupTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.createBackup(), 0L, 1200L * (long)intervalHours);
    }

    public void createBackup() {
        try {
            File[] filesToBackup;
            File dataFolder = this.plugin.getDataFolder();
            File backupFolder = new File(dataFolder, "backups");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = sdf.format(new Date());
            File backupDir = new File(backupFolder, "backup_" + timestamp);
            backupDir.mkdirs();
            for (File file : filesToBackup = new File[]{new File(dataFolder, "balances.yml"), new File(dataFolder, "stats.yml"), new File(dataFolder, "banking.yml"), new File(dataFolder, "corporations.yml"), new File(dataFolder, "currencies.yml"), new File(dataFolder, "economy.yml"), new File(dataFolder, "taxes.yml"), new File(dataFolder, "events.yml"), new File(dataFolder, "config.yml")}) {
                if (!file.exists()) continue;
                File backupFile = new File(backupDir, file.getName());
                Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            File languagesFolder = new File(dataFolder, "languages");
            if (languagesFolder.exists()) {
                File backupLanguages = new File(backupDir, "languages");
                this.copyDirectory(languagesFolder, backupLanguages);
            }
            this.plugin.getLogger().info("Backup created: " + backupDir.getName());
            this.cleanOldBackups(backupFolder);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error creating backup: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void copyDirectory(File source, File target) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) != null) {
            for (File file : files) {
                File targetFile = new File(target, file.getName());
                if (file.isDirectory()) {
                    this.copyDirectory(file, targetFile);
                    continue;
                }
                Files.copy(file.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void cleanOldBackups(File backupFolder) {
        File[] backups = backupFolder.listFiles(File::isDirectory);
        int maxBackups = this.plugin.getConfigManager().getMaxBackupsToKeep();
        if (backups == null || backups.length <= maxBackups) {
            return;
        }
        Arrays.sort(backups, (a, b) -> Long.compare(a.lastModified(), b.lastModified()));
        int toDelete = backups.length - maxBackups;
        for (int i = 0; i < toDelete; ++i) {
            this.deleteDirectory(backups[i]);
            this.plugin.getLogger().info("Old backup deleted: " + backups[i].getName());
        }
    }

    private void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        directory.delete();
    }

    public void shutdown() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
        }
    }
}

