/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.cache;

import fr.skynex.myEconomy.MyEconomy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BalanceCache {
    private final Map<UUID, CachedBalance> cache;
    private final ScheduledExecutorService scheduler;
    private final MyEconomy plugin;
    private long cacheTTL;

    public BalanceCache(MyEconomy plugin) {
        this.plugin = plugin;
        this.cache = new ConcurrentHashMap<UUID, CachedBalance>();
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.cacheTTL = plugin.getConfigManager().getBalanceCacheTTL();
        int cleanupInterval = plugin.getConfigManager().getCacheCleanupInterval();
        this.scheduler.scheduleAtFixedRate(this::cleanExpiredEntries, 1L, cleanupInterval, TimeUnit.MINUTES);
    }

    public void reloadConfig() {
        this.cacheTTL = this.plugin.getConfigManager().getBalanceCacheTTL();
    }

    public Double get(UUID playerId) {
        CachedBalance cached = this.cache.get(playerId);
        if (cached != null && !cached.isExpired(System.currentTimeMillis(), this.cacheTTL)) {
            return cached.getValue();
        }
        return null;
    }

    public void put(UUID playerId, double balance) {
        this.cache.put(playerId, new CachedBalance(balance, System.currentTimeMillis()));
    }

    public void invalidate(UUID playerId) {
        this.cache.remove(playerId);
    }

    public void invalidateAll() {
        this.cache.clear();
    }

    private void cleanExpiredEntries() {
        long now = System.currentTimeMillis();
        this.cache.entrySet().removeIf(entry -> ((CachedBalance)entry.getValue()).isExpired(now, this.cacheTTL));
    }

    public void shutdown() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class CachedBalance {
        private final double value;
        private final long timestamp;

        public CachedBalance(double value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        public double getValue() {
            return this.value;
        }

        public boolean isExpired(long now, long cacheTTL) {
            return now - this.timestamp > cacheTTL * 1000L;
        }
    }
}

