/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.commands;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.SecurityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor,
TabCompleter {
    private final EconomyManager economyManager;
    private final MyEconomy plugin;

    public PayCommand(EconomyManager economyManager) {
        this.economyManager = economyManager;
        this.plugin = MyEconomy.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-only"));
            return true;
        }
        if (!sender.hasPermission("myeconomy.pay")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        Player player = (Player)sender;
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            SecurityManager.PendingTransaction pending = this.plugin.getSecurityManager().getPendingConfirmation(player);
            if (pending == null) {
                player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-no-pending"));
                return true;
            }
            OfflinePlayer targetOffline = this.plugin.getServer().getOfflinePlayer(pending.getTarget());
            if (!targetOffline.hasPlayedBefore() && !targetOffline.isOnline()) {
                player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-target-offline"));
                this.plugin.getSecurityManager().clearPendingConfirmation(player);
                return true;
            }
            return this.executeTransfer(player, targetOffline, pending.getAmount());
        }
        if (args.length < 2) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-usage"));
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("player", args[0]);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-not-found", errorPlaceholders));
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-self"));
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("amount", args[1]);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
            return true;
        }
        if (amount <= 0.0) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative"));
            return true;
        }
        if (Double.isNaN(amount) || Double.isInfinite(amount)) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount"));
            return true;
        }
        double minAmount = this.plugin.getConfigManager().getPayMinAmount();
        double maxAmount = this.plugin.getConfigManager().getPayMaxAmount();
        if (amount < minAmount) {
            HashMap<String, String> minPlaceholders = new HashMap<String, String>();
            minPlaceholders.put("amount", String.format("%.2f", minAmount));
            minPlaceholders.put("coins", currency);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-min-amount", minPlaceholders));
            return true;
        }
        if (amount > maxAmount) {
            HashMap<String, String> maxPlaceholders = new HashMap<String, String>();
            maxPlaceholders.put("amount", String.format("%.2f", maxAmount));
            maxPlaceholders.put("coins", currency);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-max-amount", maxPlaceholders));
            return true;
        }
        SecurityManager security = this.plugin.getSecurityManager();
        if (!security.canMakeTransaction(player)) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-too-many-transactions"));
            return true;
        }
        if (security.requiresConfirmation(amount)) {
            security.addPendingConfirmation(player, new SecurityManager.PendingTransaction(target.getUniqueId(), amount));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.format("%.2f", amount));
            placeholders.put("coins", currency);
            placeholders.put("target", target.getName() != null ? target.getName() : args[0]);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-confirmation-required", placeholders));
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-confirm-instruction"));
            return true;
        }
        return this.executeTransfer(player, target, amount);
    }

    private boolean executeTransfer(Player player, OfflinePlayer target, double amount) {
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        double balance = this.economyManager.getBalance(player);
        if (!this.economyManager.hasBalance(player, amount)) {
            String currencyDisplay = balance <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : currency;
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("balance", String.format("%.2f", balance));
            errorPlaceholders.put("coins", currencyDisplay);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-insufficient-balance", errorPlaceholders));
            return true;
        }
        double taxPercentage = this.plugin.getConfigManager().getPayTaxPercentage();
        double tax = amount * (taxPercentage / 100.0);
        double totalAmount = amount + tax;
        if (!this.economyManager.hasBalance(player, totalAmount)) {
            String currencyDisplay = balance <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : currency;
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("balance", String.format("%.2f", balance));
            errorPlaceholders.put("coins", currencyDisplay);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-insufficient-with-tax", errorPlaceholders));
            return true;
        }
        if (this.economyManager.transfer(player.getUniqueId(), target.getUniqueId(), amount, tax)) {
            String targetName;
            this.plugin.getSecurityManager().recordTransaction(player);
            this.plugin.getStatsManager().recordTransaction(player.getUniqueId(), amount, "sent");
            this.plugin.getStatsManager().recordTransaction(target.getUniqueId(), amount, "received");
            String string = targetName = target.getName() != null ? target.getName() : target.getUniqueId().toString();
            if (amount >= this.plugin.getConfigManager().getPayConfirmationThreshold()) {
                this.plugin.getAuditLogger().logLargeTransaction(player.getUniqueId(), target.getUniqueId(), amount, "Transfer with tax: " + tax);
                this.plugin.getDiscordWebhook().sendLargeTransaction(player.getName(), targetName, amount);
            } else {
                this.plugin.getAuditLogger().logTransaction("PAY", player.getUniqueId(), target.getUniqueId(), amount, "Transfer between players");
            }
            String taxInfo = "";
            if (tax > 0.0) {
                HashMap<String, String> taxPlaceholders = new HashMap<String, String>();
                taxPlaceholders.put("tax", String.format("%.2f", tax));
                taxInfo = this.plugin.getLanguageManager().getMessage("pay-tax-info", taxPlaceholders);
            }
            HashMap<String, String> sentPlaceholders = new HashMap<String, String>();
            sentPlaceholders.put("amount", String.format("%.2f", amount));
            sentPlaceholders.put("coins", currency);
            sentPlaceholders.put("target", targetName);
            sentPlaceholders.put("tax", taxInfo);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("pay-sent", sentPlaceholders));
            if (target.isOnline() && target.getPlayer() != null) {
                Player targetPlayer = target.getPlayer();
                HashMap<String, String> receivedPlaceholders = new HashMap<String, String>();
                receivedPlaceholders.put("amount", String.format("%.2f", amount));
                receivedPlaceholders.put("coins", currency);
                receivedPlaceholders.put("sender", player.getName());
                targetPlayer.sendMessage(this.plugin.getLanguageManager().getMessage("pay-received", receivedPlaceholders));
                this.plugin.getNotificationManager().sendTransactionSuccess(targetPlayer, "Received", amount, player.getName());
                this.plugin.getNotificationManager().sendBalanceUpdate(targetPlayer, this.plugin.getEconomyManager().getBalance(targetPlayer), amount);
            }
            this.plugin.getNotificationManager().sendTransactionSuccess(player, "Payment", amount, targetName);
            this.plugin.getNotificationManager().sendBalanceUpdate(player, this.plugin.getEconomyManager().getBalance(player), -totalAmount);
        } else {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("error-transfer-failed"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            if ("confirm".startsWith(input)) {
                completions.add("confirm");
            }
            for (OfflinePlayer op : this.plugin.getServer().getOfflinePlayers()) {
                String name = op.getName();
                if (name == null || !name.toLowerCase().startsWith(input) || !(sender instanceof Player) || op.getUniqueId().equals(((Player)sender).getUniqueId())) continue;
                completions.add(name);
            }
        }
        return completions;
    }
}

