/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.commands;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.StatsManager;
import fr.skynex.myEconomy.util.CurrencyFormatter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TransactionsCommand
implements CommandExecutor,
TabCompleter {
    private final MyEconomy plugin;
    private static final int DEFAULT_LIMIT = 10;
    private static final int MAX_LIMIT = 50;

    public TransactionsCommand(MyEconomy plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("myeconomy.transactions") && !player.hasPermission("myeconomy.admin")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        if (args.length > 0 && player.hasPermission("myeconomy.admin") && !this.isNumeric(args[0])) {
            OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
            if (!target.hasPlayedBefore() && !target.isOnline()) {
                HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                errorPlaceholders.put("player", args[0]);
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-not-found", errorPlaceholders));
                return true;
            }
            return this.showTransactions(player, target.getUniqueId(), args.length > 1 ? this.parsePage(args[1]) : 1);
        }
        return this.showTransactions(player, player.getUniqueId(), args.length > 0 ? this.parsePage(args[0]) : 1);
    }

    private boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private int parsePage(String arg) {
        try {
            return Math.max(1, Integer.parseInt(arg));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private boolean showTransactions(Player viewer, UUID targetUuid, int page) {
        String dbType = this.plugin.getConfigManager().getDatabaseType();
        if (!dbType.equals("mysql") && !dbType.equals("sqlite")) {
            viewer.sendMessage(this.plugin.getLanguageManager().getMessage("transactions-yaml-unavailable"));
            return true;
        }
        List<StatsManager.TransactionRecord> transactions = this.plugin.getStatsManager().getPlayerTransactions(targetUuid, 50 * page);
        if (transactions.isEmpty()) {
            viewer.sendMessage(this.plugin.getLanguageManager().getMessage("transactions-empty"));
            return true;
        }
        int start = (page - 1) * 10;
        int end = Math.min(start + 10, transactions.size());
        List<StatsManager.TransactionRecord> pageTransactions = transactions.subList(start, end);
        CurrencyFormatter formatter = new CurrencyFormatter(this.plugin);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm");
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        String targetName = viewer.getUniqueId().equals(targetUuid) ? "Your" : (Bukkit.getOfflinePlayer((UUID)targetUuid).getName() != null ? Bukkit.getOfflinePlayer((UUID)targetUuid).getName() + "'s" : "Player's");
        HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
        headerPlaceholders.put("player", targetName);
        headerPlaceholders.put("page", String.valueOf(page));
        viewer.sendMessage(this.plugin.getLanguageManager().getMessage("transactions-header", headerPlaceholders));
        for (int i = 0; i < pageTransactions.size(); ++i) {
            StatsManager.TransactionRecord tx = pageTransactions.get(i);
            String typeStr = this.formatType(tx.getType(), tx.isIncoming());
            String amountStr = formatter.formatShort(tx.getAmount());
            String dateStr = sdf.format(new Date(tx.getTimestamp()));
            String line = this.plugin.getLanguageManager().getMessage("transactions-line").replace("{type}", typeStr).replace("{amount}", amountStr).replace("{currency}", currency).replace("{date}", dateStr);
            viewer.sendMessage(line);
        }
        if (end < transactions.size()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("page", String.valueOf(page + 1));
            viewer.sendMessage(this.plugin.getLanguageManager().getMessage("transactions-next-page", placeholders));
        }
        return true;
    }

    private String formatType(String type, boolean incoming) {
        switch (type.toLowerCase()) {
            case "sent": {
                return "\u00a7cSent";
            }
            case "received": {
                return "\u00a7aReceived";
            }
            case "earned": {
                return "\u00a7aEarned";
            }
            case "spent": {
                return "\u00a7cSpent";
            }
        }
        return incoming ? "\u00a7a+" : "\u00a7c-";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("myeconomy.admin")) {
            String input = args[0].toLowerCase();
            for (OfflinePlayer op : this.plugin.getServer().getOfflinePlayers()) {
                String name = op.getName();
                if (name == null || !name.toLowerCase().startsWith(input)) continue;
                completions.add(name);
            }
        }
        return completions;
    }
}

