/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.constants;

public final class Permissions {
    public static final String ALL = "myeconomy.*";
    public static final String ADMIN = "myeconomy.admin";
    public static final String ADMIN_HOLOGRAM = "myeconomy.admin.hologram";
    public static final String PLAYER = "myeconomy.player";
    public static final String BALANCE = "myeconomy.balance";
    public static final String BALANCE_OTHERS = "myeconomy.balance.others";
    public static final String PAY = "myeconomy.pay";
    public static final String BALTOP = "myeconomy.baltop";
    public static final String MENU = "myeconomy.menu";
    public static final String TRANSACTIONS = "myeconomy.transactions";

    private Permissions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isAdminPermission(String permission) {
        return permission != null && permission.startsWith(ADMIN);
    }

    public static boolean isPlayerPermission(String permission) {
        return permission != null && (permission.equals(BALANCE) || permission.equals(PAY) || permission.equals(BALTOP) || permission.equals(MENU) || permission.equals(TRANSACTIONS));
    }

    public static String[] getPlayerPermissions() {
        return new String[]{BALANCE, PAY, BALTOP, MENU, TRANSACTIONS};
    }

    public static String[] getAdminPermissions() {
        return new String[]{ADMIN, ADMIN_HOLOGRAM};
    }
}

