/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.gui;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.StatsManager;
import fr.skynex.myEconomy.gui.GUIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class MainEconomyGUI
implements Listener {
    private final MyEconomy plugin;
    private final Map<UUID, String> playerMenus;
    private final Map<UUID, UUID> playerPayTarget;
    private final Map<UUID, UUID> playerAdminTarget;
    private final Map<UUID, String> playerAdminAction;

    public MainEconomyGUI(MyEconomy plugin) {
        this.plugin = plugin;
        this.playerMenus = new HashMap<UUID, String>();
        this.playerPayTarget = new HashMap<UUID, UUID>();
        this.playerAdminTarget = new HashMap<UUID, UUID>();
        this.playerAdminAction = new HashMap<UUID, String>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private GUIConfig cfg() {
        return this.plugin.getGUIConfig();
    }

    public void openMainMenu(Player player) {
        String[] categories;
        Inventory inv = Bukkit.createInventory(null, (int)this.cfg().getMainMenuSize(), (Component)this.text(this.cfg().getMainMenuTitle()));
        this.fillBorder(inv);
        this.playOpenSound(player);
        double balance = this.plugin.getEconomyManager().getBalance(player);
        StatsManager.PlayerStats stats = this.plugin.getStatsManager().getStats(player.getUniqueId());
        String currency = this.plugin.getConfigManager().getCurrencyName();
        ArrayList<String> fortuneLore = new ArrayList<String>();
        for (String line : this.cfg().getFortuneLore()) {
            fortuneLore.add(line.replace("{balance}", String.format("%.2f", balance)).replace("{currency}", currency).replace("{earned}", String.format("%.0f", stats.getTotalEarned())).replace("{spent}", String.format("%.0f", stats.getTotalSpent())).replace("{transactions}", String.valueOf(stats.getTransactionsCount())));
        }
        inv.setItem(this.cfg().getFortuneSlot(), this.createItem(this.cfg().getFortuneMaterial(), this.cfg().getFortuneName(), fortuneLore));
        inv.setItem(this.cfg().getPaySlot(), this.createItem(this.cfg().getPayMaterial(), this.cfg().getPayName(), this.cfg().getPayLore()));
        inv.setItem(this.cfg().getTopGlobalSlot(), this.createItem(this.cfg().getTopGlobalMaterial(), this.cfg().getTopGlobalName(), this.cfg().getTopGlobalLore()));
        inv.setItem(this.cfg().getTopWeeklySlot(), this.createItem(this.cfg().getTopWeeklyMaterial(), this.cfg().getTopWeeklyName(), this.cfg().getTopWeeklyLore()));
        inv.setItem(this.cfg().getTopMonthlySlot(), this.createItem(this.cfg().getTopMonthlyMaterial(), this.cfg().getTopMonthlyName(), this.cfg().getTopMonthlyLore()));
        for (String cat : categories = new String[]{"minerais", "bois", "pierres", "nourriture", "equipement", "redstone", "decorations", "magie", "rares"}) {
            int slot = this.cfg().getCategorySlot(cat);
            if (slot <= 0) continue;
            inv.setItem(slot, this.createItem(this.cfg().getCategoryMaterial(cat), this.cfg().getCategoryName(cat), this.cfg().getCategoryLore(cat)));
        }
        if (player.hasPermission("myeconomy.admin") || player.isOp()) {
            inv.setItem(this.cfg().getAdminSlot(), this.createItem(this.cfg().getAdminMaterial(), this.cfg().getAdminName(), this.cfg().getAdminLore()));
        }
        inv.setItem(this.cfg().getCloseSlot(), this.createItem(this.cfg().getCloseMaterial(), this.cfg().getCloseName(), new ArrayList<String>()));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "main");
    }

    public void openTopMenu(Player player, String type) {
        Inventory inv = Bukkit.createInventory(null, (int)this.cfg().getRankingsSize(), (Component)this.text(this.cfg().getRankingsTitle(type)));
        this.fillBorder(inv);
        this.playOpenSound(player);
        List<Map.Entry<UUID, Double>> top = switch (type) {
            case "weekly" -> this.plugin.getRankingManager().getWeeklyTop(10);
            case "monthly" -> this.plugin.getRankingManager().getMonthlyTop(10);
            default -> this.plugin.getRankingManager().getTopBalances(10);
        };
        String currency = this.plugin.getConfigManager().getCurrencyName();
        List<Integer> slots = this.cfg().getRankingsSlots();
        int rank = 1;
        for (Map.Entry<UUID, Double> entry : top) {
            if (rank > 10 || rank > slots.size()) break;
            OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            String name = offPlayer.getName() != null ? offPlayer.getName() : "Unknown";
            double bal = entry.getValue();
            String color = this.cfg().getRankingColor(rank);
            String displayName = this.cfg().getRankingEntryName().replace("{color}", color).replace("{position}", String.valueOf(rank)).replace("{player}", name);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : this.cfg().getRankingEntryLore()) {
                lore.add(line.replace("{balance}", String.format("%.2f", bal)).replace("{currency}", currency));
            }
            ItemStack item = rank <= 3 ? this.createPlayerHead(offPlayer, displayName, lore) : this.createItem(this.cfg().getRankingMaterial(rank), displayName, lore);
            inv.setItem(slots.get(rank - 1).intValue(), item);
            ++rank;
        }
        if (top.isEmpty()) {
            inv.setItem(22, this.createItem(Material.BARRIER, "\u00a7cNo players", List.of("\u00a77The ranking is empty")));
        }
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Main menu")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "top_" + type);
    }

    public void openPayMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)this.cfg().getPayMenuSize(), (Component)this.text(this.cfg().getPayMenuTitle()));
        this.fillBorder(inv);
        this.playOpenSound(player);
        double balance = this.plugin.getEconomyManager().getBalance(player);
        String currency = this.plugin.getConfigManager().getCurrencyName();
        inv.setItem(4, this.createItem(Material.GOLD_BLOCK, "\u00a76\u00a7lYour Balance", List.of("\u00a7e" + String.format("%.2f", balance) + " " + currency)));
        ArrayList online = new ArrayList(Bukkit.getOnlinePlayers());
        online.remove(player);
        if (online.isEmpty()) {
            inv.setItem(22, this.createItem(Material.BARRIER, "\u00a7cNo players online", new ArrayList<String>()));
        } else {
            int slot = 19;
            for (Player target : online) {
                if (slot >= 44) break;
                if (slot == 26 || slot == 35) {
                    slot += 2;
                }
                inv.setItem(slot++, this.createPlayerHead((OfflinePlayer)target, "\u00a7e" + target.getName(), List.of("\u00a77Click to pay")));
            }
        }
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Main menu")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "pay");
    }

    public void openPayAmountMenu(Player player, Player target) {
        this.playerPayTarget.put(player.getUniqueId(), target.getUniqueId());
        String title = this.cfg().getPayAmountMenuTitle().replace("{player}", target.getName());
        Inventory inv = Bukkit.createInventory(null, (int)45, (Component)this.text(title));
        this.fillBorder(inv);
        this.playOpenSound(player);
        double balance = this.plugin.getEconomyManager().getBalance(player);
        String currency = this.plugin.getConfigManager().getCurrencyName();
        inv.setItem(4, this.createItem(Material.GOLD_BLOCK, "\u00a76\u00a7lYour Balance", List.of("\u00a7e" + String.format("%.2f", balance) + " " + currency)));
        int[] amounts = new int[]{10, 50, 100, 500, 1000, 5000, 10000};
        int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25};
        for (int i = 0; i < amounts.length; ++i) {
            if (!((double)amounts[i] <= balance)) continue;
            inv.setItem(slots[i], this.createItem(Material.GOLD_INGOT, "\u00a7e" + amounts[i] + " " + currency, List.of("\u00a77Send this amount")));
        }
        if (balance > 0.0) {
            inv.setItem(31, this.createItem(Material.GOLD_BLOCK, "\u00a76\u00a7lAll (" + (int)balance + ")", List.of("\u00a77Send all")));
        }
        inv.setItem(40, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Player selection")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "pay_amount");
    }

    public void openAdminMenu(Player player) {
        if (!player.hasPermission("myeconomy.admin") && !player.isOp()) {
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)this.cfg().getAdminMenuSize(), (Component)this.text(this.cfg().getAdminMenuTitle()));
        this.fillBorder(inv);
        this.playOpenSound(player);
        inv.setItem(20, this.createItem(Material.EMERALD, "\u00a7a\u00a7lGive", List.of("\u00a77/eco give")));
        inv.setItem(22, this.createItem(Material.REDSTONE, "\u00a7c\u00a7lTake", List.of("\u00a77/eco take")));
        inv.setItem(24, this.createItem(Material.GOLD_BLOCK, "\u00a7e\u00a7lSet", List.of("\u00a77/eco set")));
        inv.setItem(31, this.createItem(Material.BARRIER, "\u00a74\u00a7lReset", List.of("\u00a77/eco reset")));
        inv.setItem(40, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Main menu")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "admin");
    }

    public void openAdminPlayerMenu(Player player, String action) {
        this.playerAdminAction.put(player.getUniqueId(), action);
        String actionTitle = action.equals("give") ? "Give" : (action.equals("take") ? "Take" : (action.equals("set") ? "Set" : "Reset"));
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)this.text("\u00a7c\u00a7l" + actionTitle + " - Player"));
        this.fillBorder(inv);
        this.playOpenSound(player);
        int slot = 19;
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (slot >= 44) break;
            if (slot == 26 || slot == 35) {
                slot += 2;
            }
            inv.setItem(slot++, this.createPlayerHead((OfflinePlayer)target, "\u00a7e" + target.getName(), List.of("\u00a77Balance: \u00a7e" + String.format("%.0f", this.plugin.getEconomyManager().getBalance(target)))));
        }
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Admin")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "admin_player");
    }

    public void openAdminAmountMenu(Player player, Player target) {
        this.playerAdminTarget.put(player.getUniqueId(), target.getUniqueId());
        String action = this.playerAdminAction.get(player.getUniqueId());
        if (action.equals("reset")) {
            player.performCommand("eco reset " + target.getName());
            player.closeInventory();
            return;
        }
        String actionTitle = action.equals("give") ? "Give to" : (action.equals("take") ? "Take from" : "Set for");
        Inventory inv = Bukkit.createInventory(null, (int)45, (Component)this.text("\u00a7c\u00a7l" + actionTitle + " " + target.getName()));
        this.fillBorder(inv);
        this.playOpenSound(player);
        inv.setItem(4, this.createPlayerHead((OfflinePlayer)target, "\u00a7e" + target.getName(), List.of("\u00a77Balance: \u00a7e" + String.format("%.0f", this.plugin.getEconomyManager().getBalance(target)))));
        int[] amounts = new int[]{100, 500, 1000, 5000, 10000, 50000, 100000};
        int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25};
        for (int i = 0; i < amounts.length; ++i) {
            inv.setItem(slots[i], this.createItem(Material.GOLD_INGOT, "\u00a7e" + amounts[i], List.of("\u00a77Click to confirm")));
        }
        inv.setItem(40, this.createItem(Material.ARROW, "\u00a77Back", List.of("\u00a77Player selection")));
        player.openInventory(inv);
        this.playerMenus.put(player.getUniqueId(), "admin_amount");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String name;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String menu = this.playerMenus.get(player.getUniqueId());
        if (menu == null) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        String string = name = meta != null && meta.displayName() != null ? LegacyComponentSerializer.legacySection().serialize(meta.displayName()) : "";
        if (menu.equals("main")) {
            this.handleMainMenuClick(player, name, clicked);
        } else if (menu.startsWith("top_")) {
            if (name.contains("Back")) {
                this.openMainMenu(player);
            }
        } else if (menu.equals("pay")) {
            this.handlePayMenuClick(player, name, clicked);
        } else if (menu.equals("pay_amount")) {
            this.handlePayAmountClick(player, name, clicked);
        } else if (menu.equals("admin")) {
            this.handleAdminMenuClick(player, name);
        } else if (menu.equals("admin_player")) {
            this.handleAdminPlayerClick(player, name, clicked);
        } else if (menu.equals("admin_amount")) {
            this.handleAdminAmountClick(player, name, clicked);
        }
    }

    private void handleMainMenuClick(Player player, String name, ItemStack clicked) {
        Material mat = clicked.getType();
        if (name.contains("Close") || mat == Material.BARRIER) {
            this.playSound(player, this.cfg().getCloseSound());
            player.closeInventory();
        } else if (mat == Material.EMERALD || name.contains("Pay")) {
            this.playSound(player, this.cfg().getPaySound());
            this.openPayMenu(player);
        } else if (name.contains("Global") || mat == Material.GOLD_BLOCK && name.contains("Top")) {
            this.playSound(player, this.cfg().getTopGlobalSound());
            this.openTopMenu(player, "global");
        } else if (name.contains("Weekly")) {
            this.playSound(player, this.cfg().getTopWeeklySound());
            this.openTopMenu(player, "weekly");
        } else if (name.contains("Monthly")) {
            this.playSound(player, this.cfg().getTopMonthlySound());
            this.openTopMenu(player, "monthly");
        } else if (name.contains("Admin") || mat == Material.COMMAND_BLOCK) {
            this.playSound(player, this.cfg().getAdminButtonSound());
            this.openAdminMenu(player);
        } else if (name.contains("Ores") || mat == Material.DIAMOND_ORE) {
            this.playSound(player, this.cfg().getCategorySound("minerais"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Ores", 0);
        } else if (name.contains("Wood") || mat == Material.OAK_LOG) {
            this.playSound(player, this.cfg().getCategorySound("bois"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Wood", 0);
        } else if (name.contains("Stones") || mat == Material.STONE) {
            this.playSound(player, this.cfg().getCategorySound("pierres"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Stones", 0);
        } else if (name.contains("Food") || mat == Material.COOKED_BEEF) {
            this.playSound(player, this.cfg().getCategorySound("nourriture"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Food", 0);
        } else if (name.contains("Equipment") || mat == Material.DIAMOND_SWORD) {
            this.playSound(player, this.cfg().getCategorySound("equipement"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Equipment", 0);
        } else if (name.contains("Redstone") || mat == Material.REDSTONE) {
            this.playSound(player, this.cfg().getCategorySound("redstone"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Redstone", 0);
        } else if (name.contains("Decorations") || mat == Material.FLOWER_POT) {
            this.playSound(player, this.cfg().getCategorySound("decorations"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Decorations", 0);
        } else if (name.contains("Magic") || mat == Material.ENCHANTING_TABLE) {
            this.playSound(player, this.cfg().getCategorySound("magie"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Magic", 0);
        } else if (name.contains("Rare") || mat == Material.NETHER_STAR) {
            this.playSound(player, this.cfg().getCategorySound("rares"));
            this.plugin.getMarketPricesGUI().openPricesMenu(player, "Rare", 0);
        }
    }

    private void handlePayMenuClick(Player player, String name, ItemStack clicked) {
        if (name.contains("Back")) {
            this.playClickSound(player);
            this.openMainMenu(player);
        } else if (clicked.getType() == Material.PLAYER_HEAD) {
            this.playClickSound(player);
            String targetName = name.replace("\u00a7e", "");
            Player target = Bukkit.getPlayer((String)targetName);
            if (target != null) {
                this.openPayAmountMenu(player, target);
            }
        }
    }

    private void handlePayAmountClick(Player player, String name, ItemStack clicked) {
        UUID targetId;
        if (name.contains("Back")) {
            this.playClickSound(player);
            this.openPayMenu(player);
        } else if ((clicked.getType() == Material.GOLD_INGOT || clicked.getType() == Material.GOLD_BLOCK) && (targetId = this.playerPayTarget.get(player.getUniqueId())) != null) {
            Player target = Bukkit.getPlayer((UUID)targetId);
            if (target != null) {
                double amount;
                if (name.contains("All")) {
                    amount = this.plugin.getEconomyManager().getBalance(player);
                } else {
                    String numStr = name.replaceAll("[^0-9]", "");
                    if (!numStr.isEmpty()) {
                        amount = Double.parseDouble(numStr);
                    } else {
                        return;
                    }
                }
                if (amount > 0.0) {
                    this.playSound(player, this.cfg().getPayConfirmSound());
                    player.closeInventory();
                    player.performCommand("pay " + target.getName() + " " + amount);
                }
            } else {
                player.sendMessage("\u00a7cPlayer is no longer online.");
                this.openPayMenu(player);
            }
        }
    }

    private void handleAdminMenuClick(Player player, String name) {
        this.playClickSound(player);
        if (name.contains("Back")) {
            this.openMainMenu(player);
        } else if (name.contains("Give")) {
            this.openAdminPlayerMenu(player, "give");
        } else if (name.contains("Take")) {
            this.openAdminPlayerMenu(player, "take");
        } else if (name.contains("Set")) {
            this.openAdminPlayerMenu(player, "set");
        } else if (name.contains("Reset")) {
            this.openAdminPlayerMenu(player, "reset");
        }
    }

    private void handleAdminPlayerClick(Player player, String name, ItemStack clicked) {
        String targetName;
        Player target;
        this.playClickSound(player);
        if (name.contains("Back")) {
            this.openAdminMenu(player);
        } else if (clicked.getType() == Material.PLAYER_HEAD && (target = Bukkit.getPlayer((String)(targetName = name.replace("\u00a7e", "")))) != null) {
            this.openAdminAmountMenu(player, target);
        }
    }

    private void handleAdminAmountClick(Player player, String name, ItemStack clicked) {
        if (name.contains("Back")) {
            this.playClickSound(player);
            String action = this.playerAdminAction.get(player.getUniqueId());
            this.openAdminPlayerMenu(player, action);
        } else if (clicked.getType() == Material.GOLD_INGOT) {
            Player target;
            UUID targetId = this.playerAdminTarget.get(player.getUniqueId());
            String action = this.playerAdminAction.get(player.getUniqueId());
            if (targetId != null && action != null && (target = Bukkit.getPlayer((UUID)targetId)) != null) {
                String numStr = name.replaceAll("[^0-9]", "");
                double amount = Double.parseDouble(numStr);
                this.playSound(player, this.cfg().getAdminConfirmSound());
                player.closeInventory();
                player.performCommand("eco " + action + " " + target.getName() + " " + amount);
            }
        } else {
            this.playSound(player, this.cfg().getAdminAmountSound());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.playerMenus.remove(event.getPlayer().getUniqueId());
        }
    }

    private void fillBorder(Inventory inv) {
        int i;
        ItemStack pane = new ItemStack(this.cfg().getBorderMaterial());
        ItemMeta meta = pane.getItemMeta();
        meta.displayName(this.text(" "));
        pane.setItemMeta(meta);
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, pane);
        }
        for (i = inv.getSize() - 9; i < inv.getSize(); ++i) {
            inv.setItem(i, pane);
        }
        for (i = 9; i < inv.getSize() - 9; i += 9) {
            inv.setItem(i, pane);
            inv.setItem(i + 8, pane);
        }
    }

    private ItemStack createItem(Material mat, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.text(name));
        if (!lore.isEmpty()) {
            ArrayList<Component> loreComponents = new ArrayList<Component>();
            for (String line : lore) {
                loreComponents.add(this.text(line));
            }
            meta.lore(loreComponents);
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(OfflinePlayer target, String name, List<String> lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(target);
        meta.displayName(this.text(name));
        if (!lore.isEmpty()) {
            ArrayList<Component> loreComponents = new ArrayList<Component>();
            for (String line : lore) {
                loreComponents.add(this.text(line));
            }
            meta.lore(loreComponents);
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private Component text(String text) {
        return LegacyComponentSerializer.legacySection().deserialize(text);
    }

    private void playOpenSound(Player player) {
        if (this.cfg().isSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 1.0f);
        }
    }

    private void playClickSound(Player player) {
        if (this.cfg().isSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        }
    }

    private void playSound(Player player, Sound sound) {
        if (this.cfg().isSoundsEnabled() && sound != null) {
            player.playSound(player.getLocation(), sound, 0.5f, 1.0f);
        }
    }

    public void openAIMenu(Player player) {
        this.openMainMenu(player);
    }
}

