/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.market;

import fr.skynex.myEconomy.MyEconomy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class MarketIntelligence {
    private final MyEconomy plugin;
    private final Map<Material, List<TransactionData>> transactionHistory;
    private final Map<Material, MarketStats> marketStats;
    private long lastStatsUpdate;
    private static final long STATS_UPDATE_INTERVAL = 60000L;

    public MarketIntelligence(MyEconomy plugin) {
        this.plugin = plugin;
        this.transactionHistory = new ConcurrentHashMap<Material, List<TransactionData>>();
        this.marketStats = new ConcurrentHashMap<Material, MarketStats>();
        this.lastStatsUpdate = 0L;
        this.startCleanupTask();
    }

    public void recordTransaction(Material material, double price, int quantity, String transactionType) {
        if (material == null || material == Material.AIR || price <= 0.0 || quantity <= 0) {
            return;
        }
        double pricePerItem = price / (double)quantity;
        this.transactionHistory.computeIfAbsent(material, k -> Collections.synchronizedList(new ArrayList())).add(new TransactionData(pricePerItem, quantity, transactionType, System.currentTimeMillis()));
        this.marketStats.remove(material);
        List<TransactionData> history = this.transactionHistory.get(material);
        if (history.size() > 1000) {
            history.sort((a, b) -> Long.compare(b.timestamp, a.timestamp));
            history.subList(1000, history.size()).clear();
        }
    }

    public double getMarketPrice(Material material, int quantity) {
        MarketStats stats = this.getMarketStats(material);
        if (stats == null || stats.averagePrice <= 0.0) {
            return 0.0;
        }
        return stats.weightedAveragePrice * (double)quantity;
    }

    public double getPricePerItem(Material material) {
        MarketStats stats = this.getMarketStats(material);
        if (stats == null || stats.averagePrice <= 0.0) {
            return 0.0;
        }
        return stats.weightedAveragePrice;
    }

    public MarketStats getMarketStats(Material material) {
        long now = System.currentTimeMillis();
        if (this.marketStats.containsKey(material) && now - this.lastStatsUpdate < 60000L) {
            return this.marketStats.get(material);
        }
        List<TransactionData> history = this.transactionHistory.get(material);
        if (history == null || history.isEmpty()) {
            return null;
        }
        long timeWindow = this.plugin.getConfigManager().getMarketLearningTimeWindow();
        long cutoffTime = now - timeWindow;
        ArrayList<TransactionData> recentTransactions = new ArrayList<TransactionData>();
        for (TransactionData data : history) {
            if (data.timestamp < cutoffTime) continue;
            recentTransactions.add(data);
        }
        if (recentTransactions.isEmpty()) {
            return null;
        }
        MarketStats stats = this.calculateStats(recentTransactions);
        this.marketStats.put(material, stats);
        this.lastStatsUpdate = now;
        return stats;
    }

    private MarketStats calculateStats(List<TransactionData> transactions) {
        if (transactions.isEmpty()) {
            return null;
        }
        ArrayList<Double> prices = new ArrayList<Double>();
        double totalValue = 0.0;
        int totalQuantity = 0;
        for (TransactionData data : transactions) {
            prices.add(data.pricePerItem);
            totalValue += data.pricePerItem * (double)data.quantity;
            totalQuantity += data.quantity;
        }
        Collections.sort(prices);
        double averagePrice = prices.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double weightedAveragePrice = totalQuantity > 0 ? totalValue / (double)totalQuantity : averagePrice;
        double medianPrice = (Double)prices.get(prices.size() / 2);
        double minPrice = (Double)prices.get(0);
        double maxPrice = (Double)prices.get(prices.size() - 1);
        double variance = prices.stream().mapToDouble(p -> Math.pow(p - averagePrice, 2.0)).average().orElse(0.0);
        double standardDeviation = Math.sqrt(variance);
        return new MarketStats(averagePrice, weightedAveragePrice, medianPrice, minPrice, maxPrice, standardDeviation, transactions.size(), totalQuantity);
    }

    public Set<Material> getTrackedMaterials() {
        return new HashSet<Material>(this.transactionHistory.keySet());
    }

    private void startCleanupTask() {
        long cleanupInterval = this.plugin.getConfigManager().getMarketLearningCleanupInterval();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            long cutoffTime = System.currentTimeMillis() - this.plugin.getConfigManager().getMarketLearningTimeWindow() * 2L;
            for (Map.Entry<Material, List<TransactionData>> entry : this.transactionHistory.entrySet()) {
                entry.getValue().removeIf(data -> data.timestamp < cutoffTime);
                if (!entry.getValue().isEmpty()) continue;
                this.transactionHistory.remove(entry.getKey());
                this.marketStats.remove(entry.getKey());
            }
        }, 0L, cleanupInterval * 20L);
    }

    public static class TransactionData {
        public final double pricePerItem;
        public final int quantity;
        public final String transactionType;
        public final long timestamp;

        public TransactionData(double pricePerItem, int quantity, String transactionType, long timestamp) {
            this.pricePerItem = pricePerItem;
            this.quantity = quantity;
            this.transactionType = transactionType;
            this.timestamp = timestamp;
        }
    }

    public static class MarketStats {
        public final double averagePrice;
        public final double weightedAveragePrice;
        public final double medianPrice;
        public final double minPrice;
        public final double maxPrice;
        public final double volatility;
        public final int transactionCount;
        public final int totalVolume;

        public MarketStats(double averagePrice, double weightedAveragePrice, double medianPrice, double minPrice, double maxPrice, double volatility, int transactionCount, int totalVolume) {
            this.averagePrice = averagePrice;
            this.weightedAveragePrice = weightedAveragePrice;
            this.medianPrice = medianPrice;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.volatility = volatility;
            this.transactionCount = transactionCount;
            this.totalVolume = totalVolume;
        }

        public double getConfidencePrice() {
            if (this.volatility > this.averagePrice * 0.5) {
                return this.medianPrice;
            }
            return this.weightedAveragePrice;
        }
    }
}

