/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.notifications;

import fr.skynex.myEconomy.MyEconomy;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NotificationManager {
    private final MyEconomy plugin;
    private final Map<UUID, NotificationQueue> playerQueues;

    public NotificationManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.playerQueues = new HashMap<UUID, NotificationQueue>();
    }

    public void sendBalanceUpdate(Player player, double newBalance, double change) {
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        String changeText = change > 0.0 ? "\u00a7a+" + String.format("%.2f", change) : "\u00a7c" + String.format("%.2f", change);
        this.sendActionBar(player, "\u00a77Balance: \u00a7e" + String.format("%.2f", newBalance) + " " + currency + " \u00a77(" + changeText + "\u00a77)");
    }

    public void sendTransactionSuccess(Player player, String type, double amount, String target) {
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        String message = "\u00a7a\u2713 " + type + " \u00a7e" + String.format("%.2f", amount) + " " + currency;
        if (target != null) {
            message = message + " \u00a77\u2192 \u00a7e" + target;
        }
        this.sendActionBar(player, message);
    }

    public void sendTransactionFailed(Player player, String reason) {
        this.sendActionBar(player, "\u00a7c\u2717 Transaction failed: \u00a77" + reason);
    }

    public void sendStockPriceAlert(Player player, String itemName, double price, double change) {
        String changeColor;
        String string = change > 0.0 ? "\u00a7a" : (changeColor = change < 0.0 ? "\u00a7c" : "\u00a77");
        String changeSymbol = change > 0.0 ? "\u25b2" : (change < 0.0 ? "\u25bc" : "\u2500");
        this.sendActionBar(player, "\u00a76" + itemName + " \u00a77: \u00a7e" + String.format("%.2f", price) + " " + changeColor + changeSymbol + " " + String.format("%.1f", Math.abs(change)) + "%");
    }

    public void sendBankInterest(Player player, double interest, double newBalance) {
        this.sendTitle(player, "\u00a7a+ " + String.format("%.2f", interest), "\u00a77New balance: \u00a7e" + String.format("%.2f", newBalance), 10, 40, 10);
    }

    public void sendLoanReminder(Player player, double amount, int daysLeft) {
        this.sendTitle(player, "\u00a7cLoan Reminder", "\u00a77Amount: \u00a7e" + String.format("%.2f", amount) + " \u00a77| Days left: \u00a7e" + daysLeft, 10, 60, 10);
    }

    public void sendMarketCrashAlert(Player player, String itemName, double crashPercentage) {
        this.sendTitle(player, "\u00a7c\ud83d\udca5 STOCK MARKET CRASH", "\u00a77" + itemName + " dropped by \u00a7c" + String.format("%.1f", crashPercentage) + "%", 20, 80, 20);
    }

    public void sendRankingReward(Player player, int position, double reward, String type) {
        this.sendTitle(player, "\u00a76\ud83c\udfc6 " + type + " Ranking", "\u00a77Position #" + position + " | Reward: \u00a7e" + String.format("%.2f", reward), 20, 60, 20);
    }

    public void sendEconomicEvent(Player player, String eventName, String description) {
        this.sendTitle(player, "\u00a76[Event] \u00a7e" + eventName, "\u00a77" + description, 20, 100, 20);
    }

    public void sendWarning(Player player, String message) {
        this.sendActionBar(player, "\u00a7c\u26a0 " + message);
    }

    public void sendInfo(Player player, String message) {
        this.sendActionBar(player, "\u00a7b\u2139 " + message);
    }

    public void sendSuccess(Player player, String message) {
        this.sendActionBar(player, "\u00a7a\u2713 " + message);
    }

    private void sendActionBar(Player player, String message) {
        TextComponent component = LegacyComponentSerializer.legacySection().deserialize(message);
        player.sendActionBar((Component)component);
    }

    private void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        TextComponent titleComponent = LegacyComponentSerializer.legacySection().deserialize(title);
        TextComponent subtitleComponent = subtitle != null && !subtitle.isEmpty() ? LegacyComponentSerializer.legacySection().deserialize(subtitle) : Component.empty();
        Title titleObj = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L)));
        player.showTitle(titleObj);
    }

    public void queueNotification(Player player, Notification notification) {
        this.playerQueues.computeIfAbsent(player.getUniqueId(), k -> new NotificationQueue(this.plugin, player)).add(notification);
    }

    private static class NotificationQueue {
        private final MyEconomy plugin;
        private final Player player;
        private final Queue<Notification> queue;
        private boolean processing;

        public NotificationQueue(MyEconomy plugin, Player player) {
            this.plugin = plugin;
            this.player = player;
            this.queue = new PriorityQueue<Notification>((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
            this.processing = false;
        }

        public void add(Notification notification) {
            this.queue.offer(notification);
            if (!this.processing) {
                this.processQueue();
            }
        }

        private void processQueue() {
            if (this.queue.isEmpty() || !this.player.isOnline()) {
                this.processing = false;
                return;
            }
            this.processing = true;
            Notification notification = this.queue.poll();
            switch (notification.getType().ordinal()) {
                case 0: {
                    TextComponent actionBarComponent = LegacyComponentSerializer.legacySection().deserialize(notification.getMessage());
                    this.player.sendActionBar((Component)actionBarComponent);
                    break;
                }
                case 1: {
                    TextComponent titleComponent = LegacyComponentSerializer.legacySection().deserialize(notification.getMessage());
                    Title titleObj = Title.title((Component)titleComponent, (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L)));
                    this.player.showTitle(titleObj);
                    break;
                }
                case 2: {
                    TextComponent subtitleComponent = LegacyComponentSerializer.legacySection().deserialize(notification.getMessage());
                    Title subtitleTitleObj = Title.title((Component)Component.empty(), (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L)));
                    this.player.showTitle(subtitleTitleObj);
                    break;
                }
                case 3: {
                    this.player.sendMessage(notification.getMessage());
                }
            }
            long delay = this.plugin.getConfigManager().getNotificationDelay();
            new BukkitRunnable(){

                public void run() {
                    this.processQueue();
                }
            }.runTaskLater((Plugin)this.plugin, delay);
        }
    }

    public static class Notification {
        private final String message;
        private final NotificationType type;
        private final int priority;

        public Notification(String message, NotificationType type, int priority) {
            this.message = message;
            this.type = type;
            this.priority = priority;
        }

        public String getMessage() {
            return this.message;
        }

        public NotificationType getType() {
            return this.type;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static enum NotificationType {
        ACTIONBAR,
        TITLE,
        SUBTITLE,
        CHAT;

    }
}

